/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.util.Arrays;
import org.openrdf.model.Statement;

public class StatementList {
    private Statement[] _statements;
    private int _size;

    public StatementList() {
        this(4);
    }

    public StatementList(int size) {
        this._statements = new Statement[size];
        this._size = 0;
    }

    public StatementList(StatementList other) {
        this(other._size);
        this.addAll(other);
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Statement get(int index) {
        if (index < 0 || index >= this._size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            throw new IndexOutOfBoundsException("index >= size");
        }
        return this._statements[index];
    }

    public void add(Statement st) {
        if (this._size == this._statements.length) {
            this._growArray(this._size == 0 ? 1 : 2 * this._size);
        }
        this._statements[this._size] = st;
        ++this._size;
    }

    public void addAll(StatementList other) {
        if (this._size + other._size >= this._statements.length) {
            this._growArray(this._size + other._size);
        }
        System.arraycopy(other._statements, 0, this._statements, this._size, other._size);
        this._size += other._size;
    }

    public void remove(int index) {
        if (index < 0 || index >= this._size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            throw new IndexOutOfBoundsException("index >= size");
        }
        if (index == this._size - 1) {
            this._statements[index] = null;
            --this._size;
        } else {
            --this._size;
            this._statements[index] = this._statements[this._size];
            this._statements[this._size] = null;
        }
    }

    public void remove(Statement st) {
        for (int i = 0; i < this._size; ++i) {
            if (this._statements[i] != st) continue;
            this.remove(i);
            return;
        }
    }

    public void clear() {
        Arrays.fill(this._statements, 0, this._size, null);
        this._size = 0;
    }

    private void _growArray(int size) {
        Statement[] newArray = new Statement[size];
        System.arraycopy(this._statements, 0, newArray, 0, this._size);
        this._statements = newArray;
    }
}

