/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.IntCollection;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.IntKeyIntMap;
import bak.pcj.map.IntKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractIntKeyIntMap
implements IntKeyIntMap {
    protected AbstractIntKeyIntMap() {
    }

    public void clear() {
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public int remove(int key) {
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            int value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultInt();
    }

    public void putAll(IntKeyIntMap map) {
        IntKeyIntMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(int key) {
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int get(int key) {
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultInt();
    }

    public boolean containsValue(int value) {
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntKeyIntMap)) {
            return false;
        }
        IntKeyIntMap map = (IntKeyIntMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            int k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultIntHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultIntHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int tget(int key) {
        int value = this.get(key);
        if (value == MapDefaults.defaultInt() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract IntCollection values();

    public abstract int put(int var1, int var2);

    public abstract int lget();

    public abstract IntSet keySet();

    public abstract IntKeyIntMapIterator entries();
}

