/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.ShortCollection;
import bak.pcj.ShortIterator;
import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortCollection
implements ShortCollection {
    protected AbstractShortCollection() {
    }

    public boolean add(short v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(ShortCollection c) {
        ShortIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        ShortIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(short v) {
        ShortIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(ShortCollection c) {
        ShortIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(short v) {
        ShortIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(ShortCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        ShortIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(ShortCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        ShortIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        ShortIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short[] toArray() {
        return this.toArray(null);
    }

    public short[] toArray(short[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new short[size];
        }
        ShortIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ShortIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }

    public abstract ShortIterator iterator();
}

