/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.component.csw.GetDomain;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.exceptions.VersionNegotiationFailedEx;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.getrecords.FieldMapper;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CswService.GetCapabilities")
public class GetCapabilities
extends AbstractOperation
implements CatalogService {
    static final String NAME = "GetCapabilities";
    @Autowired
    private LuceneConfig _luceneConfig;
    @Autowired
    private CatalogConfiguration _catalogConfig;
    @Autowired
    private FieldMapper _fieldMapper;
    @Autowired
    private SchemaManager _schemaManager;
    @Autowired
    private NodeInfo nodeinfo;
    @Autowired
    private SourceRepository sourceRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private AccessManager accessManager;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        String message;
        Element capabilities;
        boolean isFromRecord;
        GeonetContext gc;
        block18: {
            Source source;
            this.checkService(request);
            this.checkAcceptVersions(request);
            gc = (GeonetContext)context.getHandlerContext("contextName");
            isFromRecord = false;
            String recordUuidToUseForCapability = ((SettingManager)gc.getBean(SettingManager.class)).getValue("system/csw/capabilityRecordUuid");
            if (!"srv".equals(context.getNodeId()) && (source = (Source)this.sourceRepository.findOne((Serializable)((Object)this.nodeinfo.getId()))).getServiceRecord() != null) {
                recordUuidToUseForCapability = source.getServiceRecord().toString();
            }
            capabilities = null;
            message = null;
            if (StringUtils.isNotEmpty((String)recordUuidToUseForCapability) && !"-1".equals(recordUuidToUseForCapability)) {
                Metadata record = this.metadataRepository.findOneByUuid(recordUuidToUseForCapability);
                if (record != null) {
                    try {
                        if (this.accessManager.isVisibleToAll(String.valueOf(record.getId()))) {
                            String conversionFilename = "record-to-csw-capabilities.xsl";
                            String requestLanguage = request.getAttributeValue("language");
                            HashMap<String, String> parameters = new HashMap<String, String>();
                            parameters.put("outputLanguage", requestLanguage == null ? "" : requestLanguage);
                            Path conversion = context.getAppPath().resolve("xml/csw/").resolve(conversionFilename);
                            capabilities = Xml.transform((Element)record.getXmlData(false), (Path)conversion, parameters);
                            isFromRecord = true;
                            break block18;
                        }
                        message = String.format("Record with UUID %s is not public and can't be used to build CSW GetCapabilities document. Choose another record or publish this one.", record.getUuid());
                        Log.warning((String)"geonetwork.csw", (Object)message);
                    }
                    catch (Exception e) {
                        message = String.format("Error during retrieval of record with UUID %s. Error is: %s.", record.getUuid(), e.getMessage());
                        Log.warning((String)"geonetwork.csw", (Object)message);
                    }
                } else {
                    message = String.format("Record with id %s is not available in the catalogue. Check the CSW configuration and choose an existing record.", recordUuidToUseForCapability);
                    Log.warning((String)"geonetwork.csw", (Object)message);
                }
            }
        }
        if (capabilities == null) {
            Path file = context.getAppPath().resolve("xml").resolve("csw").resolve("capabilities.xml");
            try {
                capabilities = Xml.loadFile((Path)file);
                if (StringUtils.isNotEmpty(message)) {
                    capabilities.addContent((Content)new Comment("WARNING: " + message));
                }
            }
            catch (JDOMException e) {
                Log.warning((String)"geonetwork.csw", (Object)String.format("XML encoding error in file /xml/csw/capabilities.xml. Error is %s.", e.getMessage()));
            }
            catch (NoSuchFileException e) {
                Log.warning((String)"geonetwork.csw", (Object)"File /xml/csw/capabilities.xml not found. Check catalogue config file.");
            }
        }
        if (capabilities == null) {
            throw new NoApplicableCodeEx("Failed to load capabilities from configuration files or from record. Check the CSW configuration.");
        }
        try {
            String cswServiceSpecificContraint = request.getChildText("filter");
            if (!isFromRecord) {
                this.setKeywords(capabilities, context, cswServiceSpecificContraint);
            }
            this.setOperationsParameters(capabilities);
            String currentLanguage = request.getAttributeValue("language");
            if (currentLanguage == null) {
                currentLanguage = context.getLanguage();
            }
            this.substitute(context, capabilities, currentLanguage);
            this.handleSections(request, capabilities);
            if (gc.isReadOnly()) {
                capabilities = this.removePublicationServices(capabilities);
            }
            return capabilities;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.csw", (Object)"Cannot load/process capabilities");
            Log.error((String)"geonetwork.csw", (Object)(" (C) StackTrace\n" + Util.getStackTrace((Throwable)e)));
            throw new NoApplicableCodeEx("Cannot load/process capabilities");
        }
    }

    private Element removePublicationServices(Element capabilities) {
        Element operationsMetadata = capabilities.getChild("OperationsMetadata", Csw.NAMESPACE_OWS);
        Element harvest = null;
        Element transaction = null;
        if (operationsMetadata != null) {
            List operations = operationsMetadata.getChildren("Operation", Csw.NAMESPACE_OWS);
            for (Element operation : operations) {
                if (operation.getAttributeValue("name").equals("Transaction")) {
                    transaction = operation;
                    continue;
                }
                if (!operation.getAttributeValue("name").equals("Harvest")) continue;
                harvest = operation;
            }
            if (harvest != null) {
                operationsMetadata.removeContent(harvest);
            }
            if (transaction != null) {
                operationsMetadata.removeContent(transaction);
            }
        }
        return capabilities;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) {
        String service = params.get("service");
        String sections = params.get("sections");
        String sequence = params.get("updatesequence");
        String acceptVers = params.get("acceptversions");
        String acceptForm = params.get("acceptformats");
        String language = params.get("language");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "updateSequence", sequence);
        this.setAttrib(request, "language", language);
        this.fill(request, "AcceptVersions", "Version", acceptVers, Csw.NAMESPACE_OWS);
        this.fill(request, "Sections", "Section", sections, Csw.NAMESPACE_OWS);
        this.fill(request, "AcceptFormats", "OutputFormat", acceptForm, Csw.NAMESPACE_OWS);
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private void checkAcceptVersions(Element request) throws CatalogException {
        Element versions = request.getChild("AcceptVersions", Csw.NAMESPACE_OWS);
        if (versions == null) {
            return;
        }
        Iterator i = versions.getChildren().iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            Element version = (Element)i.next();
            if (version.getText().equals("2.0.2")) {
                return;
            }
            sb.append(version.getText());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        throw new VersionNegotiationFailedEx(sb.toString());
    }

    private void handleSections(Element request, Element capabilities) {
        Element sections = request.getChild("Sections", Csw.NAMESPACE_OWS);
        if (sections == null) {
            return;
        }
        HashSet<String> hsSections = new HashSet<String>();
        for (Object o : sections.getChildren()) {
            Element section = (Element)o;
            String sectionName = section.getText();
            if (!sectionName.equals("ServiceIdentification") && !sectionName.equals("ServiceProvider") && !sectionName.equals("OperationsMetadata")) continue;
            hsSections.add(sectionName);
        }
        if (!hsSections.contains("ServiceIdentification")) {
            capabilities.getChild("ServiceIdentification", Csw.NAMESPACE_OWS).detach();
        }
        if (!hsSections.contains("ServiceProvider")) {
            capabilities.getChild("ServiceProvider", Csw.NAMESPACE_OWS).detach();
        }
        if (!hsSections.contains("OperationsMetadata")) {
            capabilities.getChild("OperationsMetadata", Csw.NAMESPACE_OWS).detach();
        }
    }

    private void substitute(ServiceContext context, Element capab, String langId) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        HashMap<String, String> vars = new HashMap<String, String>();
        String protocol = sm.getValue("system/server/protocol");
        vars.put("$PROTOCOL", protocol);
        vars.put("$HOST", sm.getValue("system/server/host"));
        String insecureport = sm.getValue("system/server/port");
        String secureport = sm.getValue("system/server/securePort");
        String port = "https".equals(protocol) ? secureport : insecureport;
        vars.put("$PORT", SettingManager.isPortRequired((String)protocol, (String)port) ? ":" + port : "");
        vars.put("$END-POINT", context.getService());
        vars.put("$NODE_ID", context.getNodeId());
        String providerName = sm.getValue("system/site/organization");
        vars.put("$PROVIDER_NAME", StringUtils.isNotEmpty((String)providerName) ? providerName : "GeoNetwork opensource");
        vars.put("$SERVLET", context.getBaseUrl());
        boolean isTitleDefined = false;
        String sourceUuid = "srv".equals(this.nodeinfo.getId()) ? sm.getSiteId() : this.nodeinfo.getId();
        Source source = (Source)this.sourceRepository.findOne((Serializable)((Object)sourceUuid));
        if (source != null) {
            vars.put("$TITLE", (String)source.getLabelTranslations().get(langId));
            isTitleDefined = true;
        } else {
            vars.put("$TITLE", sm.getSiteName());
        }
        vars.put("$LOCALE", langId);
        Lib.element.substitute(capab, vars);
    }

    private void setInspireLanguages(Element capabilities, List<String> languages, String currLang, String defaultLang) {
        Element inspireExtCapabilities = capabilities.getChild("OperationsMetadata", Csw.NAMESPACE_OWS).getChild("ExtendedCapabilities", Csw.NAMESPACE_INSPIRE_DS);
        Element inspireLanguages = inspireExtCapabilities.getChild("SupportedLanguages", Csw.NAMESPACE_INSPIRE_COM);
        if (defaultLang == null) {
            defaultLang = "eng";
        }
        try {
            List inspireLanguagesChildren;
            Element language;
            for (String lang : languages) {
                if (!lang.equalsIgnoreCase(defaultLang)) continue;
                Element defaultLanguage = new Element("DefaultLanguage", Csw.NAMESPACE_INSPIRE_COM);
                language = new Element("Language", Csw.NAMESPACE_INSPIRE_COM);
                language.setText(lang);
                List defaultLangChildren = defaultLanguage.getChildren();
                defaultLangChildren.add(language);
                inspireLanguagesChildren = inspireLanguages.getChildren();
                inspireLanguagesChildren.add(defaultLanguage);
                break;
            }
            for (String lang : languages) {
                if (lang.equalsIgnoreCase(defaultLang)) continue;
                Element supportedLanguage = new Element("SupportedLanguage", Csw.NAMESPACE_INSPIRE_COM);
                language = new Element("Language", Csw.NAMESPACE_INSPIRE_COM);
                language.setText(lang);
                List supportedLanguageChildren = supportedLanguage.getChildren();
                supportedLanguageChildren.add(language);
                inspireLanguagesChildren = inspireLanguages.getChildren();
                inspireLanguagesChildren.add(supportedLanguage);
            }
            HashMap<String, String> vars = new HashMap<String, String>();
            if (languages.contains(currLang)) {
                vars.put("$INSPIRE_LOCALE", currLang);
            } else {
                vars.put("$INSPIRE_LOCALE", defaultLang);
            }
            Lib.element.substitute(capabilities, vars);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.csw", (Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void setKeywords(Element capabilities, ServiceContext context, String cswServiceSpecificContraint) {
        block3: {
            List<Element> values;
            Element serviceIdentificationEl = capabilities.getChild("ServiceIdentification", Csw.NAMESPACE_OWS);
            List keywords = serviceIdentificationEl.getChildren("Keywords", Csw.NAMESPACE_OWS);
            String[] properties = new String[]{"keyword"};
            try {
                values = GetDomain.handlePropertyName(this._catalogConfig, properties, context, true, this._catalogConfig.getMaxNumberOfRecordsForKeywords(), cswServiceSpecificContraint, this._luceneConfig);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.csw", (Object)("Error getting domain value for specified PropertyName : " + e));
                return;
            }
            Iterator iterator = keywords.iterator();
            if (!iterator.hasNext()) break block3;
            Element k = (Element)iterator.next();
            int cpt = 0;
            for (Element v : values) {
                Element keyword = new Element("Keyword", Csw.NAMESPACE_OWS);
                keyword.setText(v.getText());
                k.addContent((Content)keyword);
                if (++cpt != this._catalogConfig.getNumberOfKeywords()) continue;
                break;
            }
            k.addContent((Content)new Element("Type", Csw.NAMESPACE_OWS).setText("theme"));
        }
    }

    private void setOperationsParameters(Element capabilities) {
        List operations = capabilities.getChild("OperationsMetadata", Csw.NAMESPACE_OWS).getChildren("Operation", Csw.NAMESPACE_OWS);
        for (Element op : operations) {
            if (op.getAttributeValue("name").equals("GetRecords")) {
                this.fillGetRecordsParams(op);
                continue;
            }
            if (op.getAttributeValue("name").equals("GetRecordById")) {
                this.populateTypeNameAndOutputSchema(op);
                continue;
            }
            if (!op.getAttributeValue("name").equals("DescribeRecord")) continue;
            this.populateTypeNameAndOutputSchema(op);
        }
    }

    private void populateTypeNameAndOutputSchema(Element op) {
        Map typenames = this._schemaManager.getHmSchemasTypenames();
        List operations = op.getChildren("Parameter", Csw.NAMESPACE_OWS);
        for (Element operation : operations) {
            if ("typeNames".equals(operation.getAttributeValue("name"))) {
                for (Map.Entry entry : typenames.entrySet()) {
                    String typeName = (String)entry.getKey();
                    Namespace ns = (Namespace)entry.getValue();
                    String typename = typeName;
                    operation.addNamespaceDeclaration(ns);
                    operation.addContent((Content)new Element("Value", Csw.NAMESPACE_OWS).setText(typename));
                }
                continue;
            }
            if (!"outputSchema".equals(operation.getAttributeValue("name"))) continue;
            for (Map.Entry entry : typenames.entrySet()) {
                Namespace ns = (Namespace)entry.getValue();
                operation.addNamespaceDeclaration(ns);
                operation.addContent((Content)new Element("Value", Csw.NAMESPACE_OWS).setText(ns.getURI()));
            }
        }
    }

    private void fillGetRecordsParams(Element op) {
        Set<String> isoQueryableMap = this._fieldMapper.getPropertiesByType("SupportedISOQueryables");
        Element isoConstraint = new Element("Constraint", Csw.NAMESPACE_OWS).setAttribute("name", "SupportedISOQueryables");
        for (String params : isoQueryableMap) {
            isoConstraint.addContent((Content)new Element("Value", Csw.NAMESPACE_OWS).setText(params));
        }
        Set<String> additionalQueryableMap = this._fieldMapper.getPropertiesByType("AdditionalQueryables");
        Element additionalConstraint = new Element("Constraint", Csw.NAMESPACE_OWS).setAttribute("name", "AdditionalQueryables");
        for (String params : additionalQueryableMap) {
            additionalConstraint.addContent((Content)new Element("Value", Csw.NAMESPACE_OWS).setText(params));
        }
        op.addContent((Content)isoConstraint);
        op.addContent((Content)additionalConstraint);
        this.populateTypeNameAndOutputSchema(op);
    }
}

