/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections.CollectionUtils;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.domain.HarvesterSetting_;
import org.fao.geonet.repository.GeonetRepositoryImpl;
import org.fao.geonet.repository.HarvesterSettingRepositoryCustom;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

public class HarvesterSettingRepositoryOverridesImpl
extends GeonetRepositoryImpl<HarvesterSetting, Integer>
implements HarvesterSettingRepositoryCustom {
    protected HarvesterSettingRepositoryOverridesImpl(Class<HarvesterSetting> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
    }

    public void delete(HarvesterSetting setting) {
        this.delete(setting.getId());
    }

    @Transactional
    @Modifying(clearAutomatically=true)
    public void delete(int settingId) {
        ArrayList toRemove = Lists.newArrayList((Object[])new Integer[]{settingId});
        for (int i = 0; i < toRemove.size(); ++i) {
            int nextParentId = (Integer)toRemove.get(i);
            toRemove.addAll(this.findAllChildIds(nextParentId));
        }
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(HarvesterSetting.class);
        Root root = delete.from(HarvesterSetting.class);
        delete.where((Expression)root.get(HarvesterSetting_.id).in((Collection)toRemove));
        this._entityManager.createQuery(delete).executeUpdate();
    }

    @Override
    public List<HarvesterSetting> findAllByPath(String pathToSetting) {
        StringTokenizer stringTokenizer = new StringTokenizer(pathToSetting, "/");
        int countTokens = stringTokenizer.countTokens();
        List<String> pathSegments = new ArrayList<String>(countTokens);
        while (stringTokenizer.hasMoreTokens()) {
            String child = stringTokenizer.nextToken();
            if (child.startsWith("id:")) {
                pathSegments.clear();
                pathSegments.add(child);
                continue;
            }
            pathSegments.add(child);
        }
        List<Object> currentSettings = new ArrayList();
        String firstSegment = (String)pathSegments.get(0);
        if (firstSegment.startsWith("id:")) {
            int id = Integer.parseInt(firstSegment.substring("id:".length()));
            HarvesterSetting harvesterSetting = (HarvesterSetting)this._entityManager.find(HarvesterSetting.class, (Object)id);
            if (harvesterSetting == null) {
                pathSegments = new ArrayList();
            } else {
                currentSettings.add(harvesterSetting);
                pathSegments = pathSegments.subList(1, pathSegments.size());
            }
        } else {
            currentSettings = this.findRoots();
            for (HarvesterSetting harvesterSetting : currentSettings) {
                if (!harvesterSetting.getName().equals(firstSegment)) continue;
                pathSegments.remove(0);
                currentSettings = Arrays.asList(harvesterSetting);
                break;
            }
        }
        for (String string : pathSegments) {
            List<Object> oldSettings = currentSettings;
            currentSettings = new LinkedList();
            for (HarvesterSetting harvesterSetting : oldSettings) {
                List<HarvesterSetting> children = this.findChildrenByName(harvesterSetting.getId(), string);
                currentSettings.addAll(children);
            }
        }
        return currentSettings;
    }

    @Override
    public HarvesterSetting findOneByPath(String pathToSetting) {
        List<HarvesterSetting> settings = this.findAllByPath(pathToSetting);
        if (settings.isEmpty()) {
            return null;
        }
        return settings.get(0);
    }

    @Override
    public List<HarvesterSetting> findRoots() {
        CriteriaBuilder criteriaBuilder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(HarvesterSetting.class);
        Root root = query.from(HarvesterSetting.class);
        query.where((Expression)criteriaBuilder.isNull((Expression)root.get(HarvesterSetting_.parent)));
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<HarvesterSetting> findAllChildren(int parentid) {
        CriteriaBuilder criteriaBuilder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(HarvesterSetting.class);
        Root root = query.from(HarvesterSetting.class);
        query.where((Expression)criteriaBuilder.equal((Expression)root.get(HarvesterSetting_.parent), (Object)parentid));
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<Integer> findAllChildIds(int parentid) {
        CriteriaBuilder criteriaBuilder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Integer.class);
        Root root = query.from(HarvesterSetting.class);
        query.where((Expression)criteriaBuilder.equal((Expression)root.get(HarvesterSetting_.parent), (Object)parentid));
        query.select((Selection)root.get(HarvesterSetting_.id));
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<HarvesterSetting> findChildrenByName(int parentid, String name) {
        CriteriaBuilder criteriaBuilder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(HarvesterSetting.class);
        Root root = query.from(HarvesterSetting.class);
        Predicate equalParentId = criteriaBuilder.equal((Expression)root.get(HarvesterSetting_.parent), (Object)parentid);
        Predicate equalName = criteriaBuilder.equal((Expression)root.get(HarvesterSetting_.name), (Object)name);
        query.where((Expression)criteriaBuilder.and((Expression)equalParentId, (Expression)equalName));
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<HarvesterSetting> findAllByNames(List<String> names) {
        CriteriaBuilder criteriaBuilder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(HarvesterSetting.class);
        Root root = query.from(HarvesterSetting.class);
        query.select((Selection)root);
        if (CollectionUtils.isNotEmpty(names)) {
            query.where((Expression)root.get(HarvesterSetting_.name).in(names));
        }
        return this._entityManager.createQuery(query).getResultList();
    }
}

