/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.Common;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.utils.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.context.ConfigurableApplicationContext;

@DisallowConcurrentExecution
public class HarvesterJob
implements Job,
InterruptableJob {
    public static final String ID_FIELD = "harvesterId";
    String harvesterId;
    AbstractHarvester<?, ?> harvester;
    private Thread _this = null;
    protected Logger log = Log.createLogger((String)"geonetwork.harvester");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.harvester.isHarvesterTypeDisabled()) {
            this.log.info("Cancelling harvester " + this.harvesterId + " execution because harvester type " + this.harvester.getType() + " is disabled in the system settings");
            context.setResult((Object)Common.OperResult.OK);
            return;
        }
        try {
            this._this = Thread.currentThread();
            this.harvester.harvest();
        }
        catch (Throwable t) {
            throw new JobExecutionException(t, false);
        }
    }

    public String getHarvesterId() {
        return this.harvesterId;
    }

    public void setHarvesterId(String harvesterId) {
        this.harvesterId = harvesterId;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        ApplicationContextHolder.set((ConfigurableApplicationContext)applicationContext);
    }

    public void setHarvester(AbstractHarvester<?, ?> harvester) {
        this.harvester = harvester;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.harvester.cancelMonitor.set(true);
        new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    HarvesterJob.this.log.error((Throwable)e);
                }
                if (HarvesterJob.this._this.isAlive()) {
                    HarvesterJob.this.log.error("Forcefully stopping harvester thread '" + HarvesterJob.this.getHarvesterId() + "'.");
                    try {
                        HarvesterJob.this._this.interrupt();
                    }
                    catch (Throwable e) {
                        HarvesterJob.this.log.error(e);
                    }
                }
            }
        }.start();
    }

    public Thread getThread() {
        return this._this;
    }
}

