/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ClosureRequireDependencyManager {
    private static final String ENCODING = System.getProperty("file.encoding", "UTF-8");
    private Map<String, Node> _modules = new HashMap<String, Node>();

    @Nonnull
    public Node addFile(@Nonnull String path, @Nonnull File javascriptFile, @Nonnull Set<String> notMinimized) throws IOException {
        String javascript = Files.toString((File)javascriptFile, (Charset)Charset.forName(ENCODING));
        return this.addFile(path, javascript, notMinimized);
    }

    @Nonnull
    public Node addFile(@Nonnull String path, @Nonnull String javascript, @Nonnull Set<String> notMinimized) {
        boolean isMinimized = true;
        for (String s : notMinimized) {
            if (!path.endsWith(s)) continue;
            isMinimized = false;
            break;
        }
        Node node = new Node(path, javascript, isMinimized);
        if (this._modules.containsKey(node.id)) {
            throw new IllegalArgumentException("Both '" + node.path + "' and '" + this._modules.get(node.id) + "' have the same provide id: " + node.id);
        }
        this._modules.put(node.id, node);
        return node;
    }

    public Collection<Node> getTransitiveDependenciesFor(String moduleId, boolean includeSelf) {
        Node module = this.getNode(moduleId);
        LinkedHashSet<Node> dependencies = new LinkedHashSet<Node>();
        for (String dependencyId : module.dependencyIds) {
            dependencies.addAll(this.getTransitiveDependenciesFor(dependencyId, false));
            dependencies.add(this.getNode(dependencyId));
        }
        return dependencies;
    }

    public Set<String> getAllModuleIds() {
        return this._modules.keySet();
    }

    public Node getNode(String moduleId) {
        Node module = this._modules.get(moduleId);
        this.isTrue(module != null, moduleId + " does not exist");
        return module;
    }

    private void isTrue(boolean check, String failureMsg) {
        if (!check) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public void validateGraph() {
        for (String moduleId : this._modules.keySet()) {
            this.detectCyle(moduleId, moduleId, new LinkedHashSet<String>());
        }
    }

    private void detectCyle(String moduleId, String sourceModule, Set<String> previousNodes) {
        if (previousNodes.contains(moduleId)) {
            throw new IllegalArgumentException("Module: " + sourceModule + " contains a cycle in its dependency graph: " + previousNodes);
        }
        previousNodes.add(moduleId);
        Node moduleNode = this._modules.get(moduleId);
        if (moduleNode == null) {
            throw new IllegalArgumentException("Found a dependency: " + moduleId + " that does not exist.  It is a transitive dependency of " + sourceModule + ".  Dependency path " + previousNodes);
        }
        for (String node : moduleNode.dependencyIds) {
            this.detectCyle(node, sourceModule, previousNodes);
        }
        previousNodes.remove(moduleId);
    }

    static class Node {
        static final String PROVIDES_PATTERN_STRING = "goog\\s*\\.\\s*provide\\s*\\(\\s*(.*?)\\s*\\)";
        static final String REQUIRE_PATTERN_STRING = "goog\\s*\\.\\s*require\\s*\\(\\s*(.*?)\\s*\\)";
        private static final Pattern SCAN_PATTERN = Pattern.compile("(goog\\s*\\.\\s*provide\\s*\\(\\s*(.*?)\\s*\\))|(goog\\s*\\.\\s*require\\s*\\(\\s*(.*?)\\s*\\))");
        final String id;
        final String path;
        final List<String> dependencyIds = new ArrayList<String>();
        final boolean isMinimized;

        private Node(@Nonnull String path, @Nonnull String javascript, boolean isMinimized) {
            this.path = path;
            this.isMinimized = isMinimized;
            this.id = this.parseJavascript(path, javascript);
        }

        private String parseJavascript(String path, String javascript) {
            String id = null;
            Matcher matcher = SCAN_PATTERN.matcher(javascript);
            while (matcher != null && matcher.find()) {
                int idStartIdx;
                String match = matcher.group().replace('\"', '\'');
                int idEndIdx = match.indexOf(39, idStartIdx = match.indexOf(39) + 1);
                if (idEndIdx < 0) {
                    throw new IllegalArgumentException(match + "does not have an id string");
                }
                String currentId = match.substring(idStartIdx, idEndIdx);
                this.idNonEmpty(match, currentId);
                if (match.contains("goog") && match.contains("require")) {
                    this.dependencyIds.add(currentId);
                    continue;
                }
                if (id != null) {
                    throw new IllegalArgumentException("More than one 'goog.provide' was found in the javascript file: " + path);
                }
                id = currentId;
            }
            if (id == null) {
                int index2;
                int index1 = path.lastIndexOf(47);
                if (Math.max(index1, index2 = path.lastIndexOf(92)) < 0) {
                    return Files.getNameWithoutExtension((String)path);
                }
                return Files.getNameWithoutExtension((String)path.substring(Math.max(index1, index2) + 1));
            }
            return id;
        }

        private void idNonEmpty(String match, String provide) {
            if (provide == null || provide.trim().isEmpty()) {
                throw new IllegalArgumentException(match + " has an empty id which is not permitted");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (!this.id.equals(node.id)) {
                return false;
            }
            return this.path.equals(node.path);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }
    }
}

