/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gml2.simple.FeatureCollectionEncoderDelegate;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.GML32FeatureCollectionEncoderDelegate;
import org.geotools.gml3.v3_2.GML;
import org.geotools.xml.Encoder;
import org.xml.sax.SAXException;

class WFS20FeatureCollectionEncoderDelegate
extends FeatureCollectionEncoderDelegate {
    public WFS20FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder) {
        super(features, encoder, (GMLDelegate)new WFS20EncoderDelegate(encoder));
    }

    static class WFS20EncoderDelegate
    extends GML32FeatureCollectionEncoderDelegate.GML32Delegate {
        static final QualifiedName MEMBER = new QualifiedName("http://www.opengis.net/wfs/2.0", GML.member.getLocalPart(), "wfs");
        static final QualifiedName TUPLE = new QualifiedName("http://www.opengis.net/wfs/2.0", "Tuple", "wfs");
        QualifiedName tuple;

        public WFS20EncoderDelegate(Encoder encoder) {
            super(encoder);
            this.member = MEMBER;
            this.tuple = TUPLE;
        }

        public boolean supportsTuples() {
            return true;
        }

        public void startTuple(GMLWriter handler) throws SAXException {
            handler.startElement(this.member, null);
            handler.startElement(this.tuple, null);
        }

        public void endTuple(GMLWriter handler) throws SAXException {
            handler.endElement(this.tuple);
            handler.endElement(this.member);
        }
    }
}

