/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.schema.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class RootHandler
extends XSIElementHandler {
    public static final String LOCALNAME = "root";
    private SchemaHandler schema;
    private URI uri;

    private RootHandler() {
    }

    public RootHandler(URI uri) {
        this.uri = uri;
        this.schema = new SchemaHandler();
    }

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.uri == null ? 1 : this.uri.hashCode());
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) {
        if ("schema".equalsIgnoreCase(localName) && "http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if (this.schema == null) {
                this.schema = new SchemaHandler();
            }
            return this.schema;
        }
        logger.warning("Starting schema with " + localName + " element.");
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes attr) throws SAXException {
        throw new SAXNotSupportedException("Should never have elements at the root level");
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public Schema getSchema() throws SAXException {
        Schema s = this.schema.compress(this.uri);
        return s;
    }

    public void startPrefixMapping(String arg0, String arg1) {
        this.schema.startPrefixMapping(arg0, arg1);
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }
}

