/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.reports;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataFileDownload;
import org.fao.geonet.domain.MetadataFileDownload_;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.MetadataFileDownloadRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataFileDownloadSpecs;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.fao.geonet.services.reports.ReportUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.Sort;

@Deprecated
public class ReportDataDownloads
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String beginDate = Util.getParam((Element)params, (String)"dateFrom");
        String endDate = Util.getParam((Element)params, (String)"dateTo");
        beginDate = beginDate + "T00:00:00";
        endDate = endDate + "T23:59:59";
        ISODate beginDateIso = new ISODate(beginDate);
        ISODate endDateIso = new ISODate(endDate);
        Set<Integer> groupList = ReportUtils.groupsForFilter(context, params);
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataFileDownload_.downloadDate})});
        List records = ((MetadataFileDownloadRepository)context.getBean(MetadataFileDownloadRepository.class)).findAll(MetadataFileDownloadSpecs.downloadDateBetweenAndByGroups((ISODate)beginDateIso, (ISODate)endDateIso, groupList), sort);
        Element response = new Element("response");
        MetadataFileUploadRepository uploadRepo = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
        for (MetadataFileDownload fileDownload : records) {
            int fileUploadId = fileDownload.getFileUploadId();
            MetadataFileUpload metadataFileUpload = (MetadataFileUpload)uploadRepo.findOne(MetadataFileUploadSpecs.hasId((int)fileUploadId));
            User user = ((UserRepository)context.getBean(UserRepository.class)).findOneByUsername(metadataFileUpload.getUserName());
            String username = user.getUsername();
            String name = user.getName() != null ? user.getName() : "";
            String surname = user.getSurname() != null ? user.getSurname() : "";
            String email = user.getEmail() != null ? user.getEmail() : "";
            String profile = user.getProfile().name();
            String requesterName = fileDownload.getRequesterName();
            String requesterMail = fileDownload.getRequesterMail();
            if (StringUtils.isEmpty((String)requesterName) && StringUtils.isNotEmpty((String)fileDownload.getUserName())) {
                User userDownload = ((UserRepository)context.getBean(UserRepository.class)).findOneByUsername(fileDownload.getUserName());
                requesterName = userDownload.getName() + " " + userDownload.getSurname();
                requesterMail = userDownload.getEmail();
            }
            String metadataTitle = ReportUtils.retrieveMetadataTitle(context, fileDownload.getMetadataId());
            String metadataUuid = ReportUtils.retrieveMetadataUuid(context, fileDownload.getMetadataId());
            Element metadataEl = new Element("record");
            metadataEl.addContent((Content)new Element("uuid").setText(metadataUuid)).addContent((Content)new Element("recordName").setText(metadataTitle)).addContent((Content)new Element("filename").setText(fileDownload.getFileName())).addContent((Content)new Element("downloaddate").setText(fileDownload.getDownloadDate())).addContent((Content)new Element("requestername").setText(requesterName)).addContent((Content)new Element("requestermail").setText(requesterMail)).addContent((Content)new Element("requesterorg").setText(fileDownload.getRequesterOrg())).addContent((Content)new Element("requestercomments").setText(fileDownload.getRequesterComments())).addContent((Content)new Element("username").setText(username)).addContent((Content)new Element("surname").setText(surname)).addContent((Content)new Element("name").setText(name)).addContent((Content)new Element("email").setText(email)).addContent((Content)new Element("profile").setText(profile)).addContent((Content)new Element("expiry_datetime").setText(metadataFileUpload.getDeletedDate()));
            response.addContent((Content)metadataEl);
        }
        return response;
    }
}

