/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.metadata;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class GetByOwner
implements Service {
    private static final String SORT_BY = "sortBy";
    private Element _response;

    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Specifications spec;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        int ownerId = context.getUserSession().getUserIdAsInt();
        Profile userProfile = context.getUserSession().getProfile();
        if (userProfile == null) {
            throw new OperationNotAllowedEx("Unauthorized user attempted to list editable metadata ");
        }
        if (userProfile == Profile.Administrator) {
            spec = Specifications.where((Specification)MetadataSpecs.isHarvested((boolean)false));
        } else if (userProfile == Profile.Reviewer || userProfile == Profile.UserAdmin) {
            List groups = ((UserGroupRepository)context.getBean(UserGroupRepository.class)).findAll(UserGroupSpecs.hasUserId((int)ownerId));
            List groupIds = Lists.transform((List)groups, (Function)new Function<UserGroup, Integer>(){

                @Nullable
                public Integer apply(@Nonnull UserGroup input) {
                    return input.getId().getGroupId();
                }
            });
            spec = Specifications.where((Specification)MetadataSpecs.isHarvested((boolean)false)).and(MetadataSpecs.isOwnedByOneOfFollowingGroups((List)groupIds));
        } else if (userProfile == Profile.Editor) {
            spec = Specifications.where((Specification)MetadataSpecs.isOwnedByUser((int)ownerId)).and(MetadataSpecs.isHarvested((boolean)false));
        } else {
            throw new OperationNotAllowedEx("Unauthorized user " + ownerId + " attempted to list editable metadata ");
        }
        String sortBy = this.sortByParameter(params);
        Sort order = null;
        if (sortBy.equals("date")) {
            order = new Sort(Sort.Direction.DESC, new String[]{Metadata_.dataInfo + "." + MetadataDataInfo_.changeDate});
        } else if (sortBy.equals("popularity")) {
            order = new Sort(Sort.Direction.DESC, new String[]{Metadata_.dataInfo + "." + MetadataDataInfo_.popularity});
        } else if (sortBy.equals("rating")) {
            order = new Sort(Sort.Direction.DESC, new String[]{Metadata_.dataInfo + "." + MetadataDataInfo_.rating});
        } else {
            throw new IllegalArgumentException("Unknown sortBy parameter: " + sortBy);
        }
        List metadataList = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findAll((Specification)spec, order);
        this._response = new Element("response");
        for (AbstractMetadata rec : metadataList) {
            String id = "" + rec.getId();
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element md = ((DataManager)gc.getBean(DataManager.class)).getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
            this._response.addContent((Content)md);
        }
        Element currentSortBySelect = new Element(SORT_BY);
        currentSortBySelect.setText(sortBy);
        this._response.addContent((Content)currentSortBySelect);
        Element response = (Element)this._response.clone();
        return response;
    }

    private String sortByParameter(Element params) {
        Element sortByEl = params.getChild(SORT_BY);
        String sortBy = null;
        sortBy = sortByEl == null ? "date" : sortByEl.getText();
        return sortBy;
    }
}

