/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.migration;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.sql.Connection;
import javax.sql.DataSource;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.ContextAwareTask;
import org.fao.geonet.DatabaseMigrationTask;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/tools/migration", "/{portal}/api/0.1/tools/migration"})
@Api(value="tools", tags={"tools"})
@Controller(value="migration")
public class MigrationApi {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="Call a migration step", nickname="callStep")
    @RequestMapping(value={"/steps/{stepName}"}, produces={"text/plain"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('Administrator')")
    public ResponseEntity<String> callStep(@ApiParam(value="Class name to execute corresponding to a migration step. See DatabaseMigrationTask.", example="org.fao.geonet.api.records.attachments.MetadataResourceDatabaseMigration", required=true) @PathVariable String stepName) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        DataSource dataSource = (DataSource)appContext.getBean(DataSource.class);
        try (Connection connection = dataSource.getConnection();){
            DatabaseMigrationTask task;
            Class<?> clazz = Class.forName(stepName);
            if (DatabaseMigrationTask.class.isAssignableFrom(clazz)) {
                task = (DatabaseMigrationTask)clazz.newInstance();
                connection.setAutoCommit(true);
                task.setContext((ApplicationContext)appContext);
                task.update(connection);
            } else {
                if (!ContextAwareTask.class.isAssignableFrom(clazz)) {
                    ResponseEntity responseEntity = new ResponseEntity((Object)String.format("'%s' is not a valid DatabaseMigrationTask or ContextAwareTask. Choose a valid migration step.", stepName), HttpStatus.BAD_REQUEST);
                    return responseEntity;
                }
                task = (ContextAwareTask)clazz.newInstance();
                task.run((ApplicationContext)ApplicationContextHolder.get());
            }
            ResponseEntity responseEntity2 = new ResponseEntity((Object)"", HttpStatus.CREATED);
            return responseEntity2;
        }
        catch (ClassNotFoundException e) {
            return new ResponseEntity((Object)String.format("Class '%s' not found. Choose a valid migration step.", e.getMessage()), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String error = ex.getMessage();
            if (ex.getCause() != null) {
                error = error + ". " + ex.getCause().getMessage();
            }
            return new ResponseEntity((Object)String.format("Error occurred during migration step '%s'. %s.", stepName, error), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

