/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import org.fao.geonet.Constants;
import org.fao.geonet.csw.common.util.Xml;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.v3_2.GML;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.jdom.Element;

public enum GeomFormat {
    WKT{
        private final transient WKTWriter wktWriter = new WKTWriter();
        private final transient WKTReader wktReader = new WKTReader();

        @Override
        public Element toElement(Geometry geom) {
            return new Element("geom").setText(this.wktWriter.write(geom));
        }

        @Override
        public Geometry parse(String geomString) throws Exception {
            if (geomString.contains("%")) {
                geomString = URLDecoder.decode(geomString, Constants.ENCODING);
            }
            if (geomString.contains("+")) {
                geomString = geomString.replace("+", " ");
            }
            return this.wktReader.read(geomString);
        }
    }
    ,
    GML3{

        @Override
        public Element toElement(Geometry geom) throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Encoder encoder = new Encoder((Configuration)gml3Config);
            encoder.setIndenting(false);
            encoder.setOmitXMLDeclaration(true);
            encoder.setNamespaceAware(true);
            encoder.encode((Object)geom, org.geotools.gml3.GML.geometryMember, (OutputStream)outputStream);
            String gmlString = outputStream.toString(Constants.ENCODING);
            return Xml.loadString((String)gmlString, (boolean)false);
        }

        @Override
        public Geometry parse(String geomString) throws Exception {
            Object value;
            geomString = GeomFormat.decode(geomString);
            try {
                Parser parser3 = new Parser((Configuration)gml3Config);
                value = parser3.parse((Reader)new StringReader(geomString));
            }
            catch (Exception e) {
                try {
                    Parser parser32 = new Parser((Configuration)gml32Config);
                    value = parser32.parse((Reader)new StringReader(geomString));
                }
                catch (Exception e2) {
                    try {
                        Parser parser2 = new Parser((Configuration)gml2Config);
                        value = parser2.parse((Reader)new StringReader(geomString));
                    }
                    catch (Exception e3) {
                        throw e;
                    }
                }
            }
            if (value instanceof HashMap) {
                return (Geometry)((HashMap)value).values().iterator().next();
            }
            return (Geometry)value;
        }
    }
    ,
    GML2{

        @Override
        public Element toElement(Geometry geom) throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Encoder encoder = new Encoder((Configuration)gml2Config);
            encoder.setIndenting(false);
            encoder.setOmitXMLDeclaration(true);
            encoder.setNamespaceAware(true);
            encoder.encode((Object)geom, org.geotools.gml2.GML.geometryMember, (OutputStream)outputStream);
            String gmlString = outputStream.toString(Constants.ENCODING);
            return Xml.loadString((String)gmlString, (boolean)false);
        }

        @Override
        public Geometry parse(String geomString) throws Exception {
            Object value;
            geomString = GeomFormat.decode(geomString);
            try {
                Parser parser2 = new Parser((Configuration)gml2Config);
                value = parser2.parse((Reader)new StringReader(geomString));
            }
            catch (Exception e) {
                try {
                    Parser parser3 = new Parser((Configuration)gml3Config);
                    value = parser3.parse((Reader)new StringReader(geomString));
                }
                catch (Exception e2) {
                    try {
                        Parser parser32 = new Parser((Configuration)gml32Config);
                        value = parser32.parse((Reader)new StringReader(geomString));
                    }
                    catch (Exception e3) {
                        throw e;
                    }
                }
            }
            if (value instanceof HashMap) {
                return (Geometry)((HashMap)value).values().iterator().next();
            }
            return (Geometry)value;
        }
    }
    ,
    GML32{

        @Override
        public Element toElement(Geometry geom) throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Encoder encoder = new Encoder((Configuration)gml3Config);
            encoder.setOmitXMLDeclaration(true);
            encoder.setNamespaceAware(true);
            encoder.setIndenting(false);
            encoder.encode((Object)geom, GML.geometryMember, (OutputStream)outputStream);
            String gmlString = outputStream.toString(Constants.ENCODING);
            return Xml.loadString((String)gmlString, (boolean)false);
        }

        @Override
        public Geometry parse(String geomString) throws Exception {
            Object value;
            geomString = GeomFormat.decode(geomString);
            try {
                Parser parser32 = new Parser((Configuration)gml32Config);
                value = parser32.parse((Reader)new StringReader(geomString));
            }
            catch (Exception e) {
                try {
                    Parser parser3 = new Parser((Configuration)gml3Config);
                    value = parser3.parse((Reader)new StringReader(geomString));
                }
                catch (Exception e2) {
                    try {
                        Parser parser2 = new Parser((Configuration)gml2Config);
                        value = parser2.parse((Reader)new StringReader(geomString));
                    }
                    catch (Exception e3) {
                        throw e;
                    }
                }
            }
            if (value instanceof HashMap) {
                return (Geometry)((HashMap)value).values().iterator().next();
            }
            return (Geometry)value;
        }
    };

    static GMLConfiguration gml2Config;
    static org.geotools.gml3.GMLConfiguration gml3Config;
    static org.geotools.gml3.v3_2.GMLConfiguration gml32Config;

    private static String decode(String geomString) throws UnsupportedEncodingException {
        if (!geomString.contains(" ")) {
            return URLDecoder.decode(geomString, Constants.ENCODING);
        }
        return geomString;
    }

    public static GeomFormat find(String geomType) {
        for (GeomFormat f : GeomFormat.values()) {
            if (!f.name().equalsIgnoreCase(geomType)) continue;
            return f;
        }
        throw new IllegalArgumentException(geomType + " is not an acceptable format.  Permitted values are: " + Arrays.toString((Object[])GeomFormat.values()));
    }

    public abstract Element toElement(Geometry var1) throws Exception;

    public abstract Geometry parse(String var1) throws Exception;

    static {
        gml2Config = new GMLConfiguration();
        gml3Config = new org.geotools.gml3.GMLConfiguration();
        gml32Config = new org.geotools.gml3.v3_2.GMLConfiguration();
    }
}

