/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.harvesting;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NoResultsFoundException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.HarvestHistory;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.SourceRepository;
import org.jdom.Content;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/harvesters", "/{portal}/api/0.1/harvesters"})
@Api(value="harvesters", tags={"harvesters"}, description="Harvester operations")
@Controller(value="harvesters")
public class HarvestersApi {
    @Autowired
    private HarvestManager harvestManager;
    @Autowired
    private SourceRepository sourceRepository;
    @Autowired
    private IMetadataUtils metadataRepository;
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private DataManager dataManager;
    @Autowired
    HarvestHistoryRepository historyRepository;

    @ApiOperation(value="Assign harvester records to a new source", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="assignHarvestedRecordToSource")
    @RequestMapping(value={"/{harvesterUuid}/assign"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=204, message="Harvester records transfered to new source."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public HttpEntity<HttpStatus> assignHarvestedRecordToSource(@ApiParam(value="The harvester UUID") @PathVariable String harvesterUuid, @ApiParam(value="The target source UUID") @RequestParam String source) throws Exception {
        long elapsedTime = System.currentTimeMillis();
        AbstractHarvester harvester = this.harvestManager.getHarvester(harvesterUuid);
        if (harvester == null) {
            throw new ResourceNotFoundException(String.format("Harvester with UUID '%s' not found. Cannot assign new source.", harvesterUuid));
        }
        Source sourceNode = this.sourceRepository.findOneByUuid(source);
        if (sourceNode == null) {
            throw new ResourceNotFoundException(String.format("Source with UUID '%s' not found. Cannot assign source to harvester records.", source));
        }
        List allHarvestedRecords = this.metadataRepository.findAllByHarvestInfo_Uuid(harvesterUuid);
        ArrayList<String> records = new ArrayList<String>(allHarvestedRecords.size());
        if (allHarvestedRecords.size() < 1) {
            throw new NoResultsFoundException(String.format("Harvester with UUID '%s' has no record to assign to source '%s'.", harvesterUuid, source));
        }
        for (AbstractMetadata record : allHarvestedRecords) {
            record.getSourceInfo().setSourceId(source);
            record.getHarvestInfo().setHarvested(false).setUri(null).setUuid(null);
            this.metadataManager.save(record);
            records.add(record.getId() + "");
        }
        this.dataManager.indexMetadata(records);
        Element historyEl = new Element("result");
        historyEl.addContent((Content)new Element("cleared").setAttribute("recordsTransfered", records.size() + ""));
        String lastRun = new DateTime().withZone(DateTimeZone.forID((String)"UTC")).toString();
        ISODate lastRunDate = new ISODate(lastRun);
        HarvestHistory history = new HarvestHistory();
        history.setDeleted(true);
        history.setElapsedTime((int)elapsedTime);
        history.setHarvestDate(lastRunDate);
        history.setHarvesterName(harvester.getParams().getName());
        history.setHarvesterType(harvester.getType());
        history.setHarvesterUuid(harvester.getParams().getUuid());
        history.setInfo(historyEl);
        history.setParams(harvester.getParams().getNodeElement());
        this.historyRepository.save((Object)history);
        return new HttpEntity((Object)HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Check if a harvester name or host already exist", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="checkHarvesterPropertyExist")
    @RequestMapping(value={"/properties/{property}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=200, message="Property does not exist."), @ApiResponse(code=404, message="A property with that value already exist."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity<HttpStatus> checkHarvesterPropertyExist(@ApiParam(value="The harvester property to check") @PathVariable String property, @ApiParam(value="The value to search") @RequestParam String exist, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Element list = this.harvestManager.get(null, context, "site[1]/name[1]");
        if (list.getChildren().stream().filter(h -> h instanceof Element).map(h -> ((Element)h).getChild("site").getChild(property).getTextTrim()).anyMatch(name -> ((String)name).equalsIgnoreCase(exist))) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

