/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import lizard.tiff.IFD;
import lizard.tiff.RawImage;
import lizard.tiff.T4Code;
import lizard.tiff.T4Node;
import lizard.tiff.T4Tables;
import lizard.util.Converter;

class CCITTG3Image
extends RawImage {
    T4Node WhiteTree;
    T4Node BlackTree;
    byte[] WhiteRun = new byte[2560];
    byte[] BlackRun = new byte[2560];
    boolean hiloBitOrder;
    int nPixels;

    public CCITTG3Image(IFD ifd) {
        super(ifd);
        int i = 0;
        while (i < 2560) {
            this.WhiteRun[i] = -1;
            this.BlackRun[i] = 0;
            ++i;
        }
        this.hiloBitOrder = ifd.GetFieldValue(266) == 2;
        this.WhiteTree = new T4Node();
        this.BlackTree = new T4Node();
        if (this.hiloBitOrder) {
            int lo;
            T4Code code;
            i = 0;
            while (i < T4Tables.WhiteCodes.length) {
                code = new T4Code(T4Tables.WhiteCodes[i]);
                if (code.bitLength <= 8) {
                    lo = Converter.reverseByte(Converter.getLoByte(code.codeWord));
                    code.codeWord = lo >>> 8 - code.bitLength;
                } else {
                    code.codeWord = Converter.reverseInt(code.codeWord) >>> 16 - code.bitLength;
                }
                this.WhiteTree.ReversedAdd(0, code);
                ++i;
            }
            i = 0;
            while (i < T4Tables.BlackCodes.length) {
                code = new T4Code(T4Tables.BlackCodes[i]);
                if (code.bitLength <= 8) {
                    lo = Converter.reverseByte(Converter.getLoByte(code.codeWord));
                    code.codeWord = lo >>> 8 - code.bitLength;
                } else {
                    code.codeWord = Converter.reverseInt(code.codeWord) >>> 16 - code.bitLength;
                }
                this.BlackTree.ReversedAdd(0, code);
                ++i;
            }
        } else {
            T4Code code;
            i = 0;
            while (i < T4Tables.WhiteCodes.length) {
                code = new T4Code(T4Tables.WhiteCodes[i]);
                this.WhiteTree.Add(0, code);
                ++i;
            }
            i = 0;
            while (i < T4Tables.BlackCodes.length) {
                code = new T4Code(T4Tables.BlackCodes[i]);
                this.BlackTree.Add(0, code);
                ++i;
            }
        }
    }

    public Image getImage() {
        if (this.imageBytes == null && this.imageStrips != null) {
            int rowsPerStrip = this.ifd.GetFieldValue(278);
            this.imageBytes = new byte[this.imageWidth * this.imageHeight];
            int i = 0;
            int n = 0;
            int rows = 0;
            int lastRow = this.imageStrips.length - 1;
            while (i < this.imageStrips.length) {
                byte[] rawStrip = this.DecodeImageStrip(this.imageStrips[i], i == lastRow ? this.imageHeight - rows : rowsPerStrip, true);
                System.arraycopy(rawStrip, 0, this.imageBytes, n, this.nPixels);
                n += this.nPixels;
                this.nPixels = 0;
                ++i;
                rows += rowsPerStrip;
            }
            this.imageStrips = null;
        } else if (this.imageBytes != null) {
            this.imageBytes = this.DecodeImage();
        } else {
            return null;
        }
        Image img = null;
        if (this.bitsPerSample == 8 && this.imageBytes != null) {
            ColorModel cm = this.makeColorModel();
            img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, cm, this.imageBytes, 0, this.imageWidth));
        }
        return img;
    }

    public Object getImageProducer() {
        if (this.imageBytes == null && this.imageStrips != null) {
            int rowsPerStrip = this.ifd.GetFieldValue(278);
            this.imageBytes = new byte[this.imageWidth * this.imageHeight];
            int i = 0;
            int n = 0;
            int rows = 0;
            int lastRow = this.imageStrips.length - 1;
            while (i < this.imageStrips.length) {
                byte[] rawStrip = this.DecodeImageStrip(this.imageStrips[i], i == lastRow ? this.imageHeight - rows : rowsPerStrip, true);
                System.arraycopy(rawStrip, 0, this.imageBytes, n, this.nPixels);
                n += this.nPixels;
                this.nPixels = 0;
                ++i;
                rows += rowsPerStrip;
            }
            this.imageStrips = null;
        } else if (this.imageBytes != null) {
            this.imageBytes = this.DecodeImage();
        } else {
            return null;
        }
        if (this.bitsPerSample == 8 && this.imageBytes != null) {
            int[] imagePixels = new int[this.imageBytes.length];
            int i = 0;
            while (i < this.imageBytes.length) {
                imagePixels[i] = this.imageBytes[i];
                ++i;
            }
            return new MemoryImageSource(this.imageWidth, this.imageHeight, imagePixels, 0, this.imageWidth);
        }
        return null;
    }

    byte[] DecodeImage() {
        System.out.println("CCITTG3Image::DecodeImage()");
        return this.DecodeImageStrip(this.imageBytes, this.imageHeight, true);
    }

    byte[] DecodeImageStrip(byte[] imageStrip, int maxLines, boolean firstStrip) {
        int j;
        int i;
        System.out.println("CCITTG3Image::DecodeImageStrip( strip, " + maxLines + " )");
        byte[] bytesArray = imageStrip;
        byte[] tmp = new byte[2];
        boolean whiteRun = true;
        int lines = 0;
        T4Code code = new T4Code();
        int expectedCount = this.imageWidth * maxLines;
        byte[] rawImage = new byte[expectedCount + 1];
        this.nPixels = 0;
        if (firstStrip) {
            i = 0;
            j = 0;
            while (bytesArray[i] == 0) {
                ++i;
            }
            j = i;
            if (this.hiloBitOrder) {
                int b = Converter.reverseByte(bytesArray[j]);
                i = 0;
                while (b >> i != 1) {
                    ++i;
                }
            } else {
                i = 0;
                while (bytesArray[j] >> i != 1) {
                    ++i;
                }
            }
            i += j * 8;
        } else {
            i = 0;
        }
        lines = 1;
        int count = bytesArray.length * 8;
        while (lines < maxLines && i < count) {
            byte b3;
            j = i / 8;
            int shift = i % 8;
            byte b1 = bytesArray[j];
            byte b2 = j + 1 < bytesArray.length ? bytesArray[j + 1] : (byte)0;
            byte by = b3 = j + 2 < bytesArray.length ? bytesArray[j + 2] : (byte)0;
            if (this.hiloBitOrder) {
                if (shift > 0) {
                    tmp[1] = (byte)(((b1 & 0xFF) >>> shift) + ((b2 & 255 >>> 8 - shift) << 8 - shift));
                    tmp[0] = (byte)(((b2 & 0xFF) >>> shift) + ((b3 & 255 >>> 8 - shift) << 8 - shift));
                } else {
                    tmp[1] = b1;
                    tmp[0] = b2;
                }
            } else if (shift > 0) {
                tmp[0] = (byte)(((b1 & 0xFF) << shift) + ((b2 & 0xFF) >> 8 - shift));
                tmp[1] = (byte)(((b2 & 0xFF) << shift) + ((b3 & 0xFF) >> 8 - shift));
            } else {
                tmp[0] = b1;
                tmp[1] = b2;
            }
            T4Node node = whiteRun ? this.WhiteTree.Find(Converter.bytesToInt(tmp)) : this.BlackTree.Find(Converter.bytesToInt(tmp));
            if (node != null) {
                code = node.code;
            }
            if (code.runLength > 0) {
                if (this.nPixels >= rawImage.length || this.nPixels + code.runLength >= rawImage.length || code.runLength >= this.WhiteRun.length || code.runLength >= this.BlackRun.length) {
                    System.out.println("nPixels=" + this.nPixels + ", code.runLength=" + code.runLength + ", rawImage.length=" + rawImage.length + ", WhiteRun.length=" + this.WhiteRun.length + ", BlackRun.length=" + this.BlackRun.length);
                    System.out.flush();
                }
                System.arraycopy(whiteRun ? this.WhiteRun : this.BlackRun, 0, rawImage, this.nPixels, code.runLength);
                this.nPixels += code.runLength;
            }
            i += code.bitLength;
            if (code.runLength == -3) {
                --lines;
                break;
            }
            if (this.nPixels > 0 && code.runLength == -1) {
                whiteRun = true;
                ++lines;
                continue;
            }
            if (code.runLength >= 64) continue;
            boolean bl = whiteRun = !whiteRun;
        }
        this.bitsPerSample = 8;
        return rawImage;
    }
}

