/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.Set;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;

public class StopwordFileParser {
    public static Set<String> parse(Path filepath) {
        LinkedHashSet<String> stopwords;
        block47: {
            if (filepath.endsWith("README.txt")) {
                return null;
            }
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("StopwordParser parsing file: " + filepath));
            }
            stopwords = null;
            try {
                Path file = filepath;
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    try (InputStream fin = IO.newInputStream((Path)file);
                         BufferedReader reader = new BufferedReader(new InputStreamReader(fin, Constants.ENCODING));
                         Scanner scanner = new Scanner(reader);){
                        while (scanner.hasNextLine()) {
                            Set<String> stopwordsFromLine = StopwordFileParser.parseLine(scanner.nextLine());
                            if (stopwordsFromLine == null) continue;
                            if (stopwords == null) {
                                stopwords = new LinkedHashSet<String>();
                            }
                            stopwords.addAll(stopwordsFromLine);
                        }
                        break block47;
                    }
                }
                Log.warning((String)"geonetwork.index", (Object)("Invalid stopwords file: " + file.toAbsolutePath()));
            }
            catch (IOException x) {
                Log.warning((String)"geonetwork.index", (Object)(x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
            }
        }
        if (stopwords != null) {
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Added # " + stopwords.size() + " stopwords"));
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.index")) {
            Log.debug((String)"geonetwork.index", (Object)"Added 0 stopwords");
        }
        return stopwords;
    }

    private static Set<String> parseLine(String line) {
        LinkedHashSet<String> stopwords = null;
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter("\\|");
        if (scanner.hasNext()) {
            String stopwordsPart = scanner.next();
            Scanner whitespaceTokenizer = new Scanner(stopwordsPart);
            while (whitespaceTokenizer.hasNext()) {
                String stopword = whitespaceTokenizer.next();
                if (stopwords == null) {
                    stopwords = new LinkedHashSet<String>();
                }
                stopwords.add(stopword);
            }
        }
        return stopwords;
    }
}

