/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.MetadataResourceDatabaseMigration;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataRelation;
import org.fao.geonet.domain.MetadataRelationId;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.MEF2Visitor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.mef.MEFVisitor;
import org.fao.geonet.kernel.mef.XmlVisitor;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRelationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class Importer {
    @Deprecated
    public static List<String> doImport(Element params, ServiceContext context, Path mefFile, Path stylePath) throws Exception {
        String fileType = Util.getParam((Element)params, (String)"file_type", (String)"mef");
        String style = Util.getParam((Element)params, (String)"styleSheet", (String)"_none_");
        String uuidAction = Util.getParam((Element)params, (String)"uuidAction", (String)"nothing");
        String source = Util.getParam((Element)params, (String)"siteId", (String)context.getBean(SettingManager.class).getSiteId());
        MetadataType isTemplate = MetadataType.lookup((String)Util.getParam((Element)params, (String)"template", (String)"n"));
        String category = Util.getParam((Element)params, (String)"category", (String)"");
        String groupId = Util.getParam((Element)params, (String)"group", (String)"");
        boolean validate = Util.getParam((Element)params, (String)"validate", (String)"off").equals("on");
        boolean assign = Util.getParam((Element)params, (String)"assign", (String)"off").equals("on");
        return Importer.doImport(fileType, MEFLib.UuidAction.parse(uuidAction), style, source, isTemplate, new String[]{category}, groupId, validate, assign, context, mefFile);
    }

    public static List<String> doImport(String fileType, MEFLib.UuidAction uuidAction, final String style, String source, MetadataType isTemplate, String[] category, String groupId, boolean validate, boolean assign, ServiceContext context, Path mefFile) throws Exception {
        IVisitor visitor;
        MEFLib.Version version;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        final DataManager dm = (DataManager)applicationContext.getBean(DataManager.class);
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        String preferredSchema = ((ServiceConfig)applicationContext.getBean(ServiceConfig.class)).getValue("preferredSchema", "iso19139");
        ArrayList<String> metadataIdMap = new ArrayList<String>();
        final ArrayList md = new ArrayList();
        final ArrayList fc = new ArrayList();
        if (fileType.equals("mef") && (version = MEFLib.getMEFVersion(mefFile)) != null && version.equals((Object)MEFLib.Version.V2)) {
            fileType = "mef2";
        }
        if (fileType.equals("single")) {
            visitor = new XmlVisitor();
        } else if (fileType.equals("mef")) {
            visitor = new MEFVisitor();
        } else if (fileType.equals("mef2")) {
            visitor = new MEF2Visitor();
        } else {
            throw new BadArgumentException("Bad file type parameter.");
        }
        final String finalPreferredSchema = preferredSchema;
        MEFLib.visit(mefFile, visitor, new IMEFVisitor((ApplicationContext)applicationContext, category, isTemplate, assign, source, sm, validate, groupId, context, uuidAction, metadataIdMap){
            final /* synthetic */ ApplicationContext val$applicationContext;
            final /* synthetic */ String[] val$category;
            final /* synthetic */ MetadataType val$isTemplate;
            final /* synthetic */ boolean val$assign;
            final /* synthetic */ String val$source;
            final /* synthetic */ SettingManager val$sm;
            final /* synthetic */ boolean val$validate;
            final /* synthetic */ String val$groupId;
            final /* synthetic */ ServiceContext val$context;
            final /* synthetic */ MEFLib.UuidAction val$uuidAction;
            final /* synthetic */ List val$metadataIdMap;
            {
                this.val$applicationContext = applicationContext;
                this.val$category = stringArray;
                this.val$isTemplate = metadataType;
                this.val$assign = bl;
                this.val$source = string3;
                this.val$sm = settingManager;
                this.val$validate = bl2;
                this.val$groupId = string4;
                this.val$context = serviceContext;
                this.val$uuidAction = uuidAction;
                this.val$metadataIdMap = list3;
            }

            @Override
            public void handleMetadata(Element metadata, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Collecting metadata:\n" + Xml.getString((Element)metadata)));
                }
                md.add(index, metadata);
            }

            @Override
            public void handleMetadataFiles(DirectoryStream<Path> metadataXmlFiles, Element info, int index) throws Exception {
                Element general;
                String infoSchema = "_none_";
                if (info != null && info.getContentSize() != 0 && (general = info.getChild("general")) != null && general.getContentSize() != 0 && general.getChildText("schema") != null) {
                    infoSchema = general.getChildText("schema");
                }
                Path lastUnknownMetadataFolderName = null;
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)"Multiple metadata files");
                }
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("info.xml says schema should be " + infoSchema));
                }
                HashMap<String, Pair> mdFiles = new HashMap<String, Pair>();
                for (Path file : metadataXmlFiles) {
                    if (file == null || !Files.isRegularFile(file, new LinkOption[0])) continue;
                    Element metadata = Xml.loadFile((Path)file);
                    try {
                        String metadataSchema = dm.autodetectSchema(metadata, null);
                        if (metadataSchema == null) continue;
                        String currFile = "Found metadata file " + file.getParent().getParent().relativize(file);
                        mdFiles.put(metadataSchema, Pair.read((Object)currFile, (Object)metadata));
                    }
                    catch (NoSchemaMatchesException e) {
                        lastUnknownMetadataFolderName = file.getParent().getParent().relativize(file);
                        Log.debug((String)"geonetwork.mef", (Object)("No schema match for " + lastUnknownMetadataFolderName + "."));
                    }
                }
                if (mdFiles.size() == 0) {
                    throw new BadFormatEx("No valid metadata file found" + (lastUnknownMetadataFolderName == null ? "" : " in " + lastUnknownMetadataFolderName) + ".");
                }
                Pair mdInform = (Pair)mdFiles.get(infoSchema);
                if (mdInform != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with info.xml schema (" + infoSchema + ")."));
                    }
                    Element metadataValidForImport = (Element)mdInform.two();
                    this.handleMetadata(metadataValidForImport, index);
                    return;
                }
                mdInform = (Pair)mdFiles.get(finalPreferredSchema);
                if (mdInform != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with preferred schema (" + finalPreferredSchema + ")."));
                    }
                    Element metadataValidForImport = (Element)mdInform.two();
                    this.handleMetadata(metadataValidForImport, index);
                    return;
                }
                String metadataSchema = (String)mdFiles.keySet().toArray()[0];
                mdInform = (Pair)mdFiles.get(metadataSchema);
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with known schema (" + metadataSchema + ")."));
                }
                Element metadataValidForImport = (Element)mdInform.two();
                this.handleMetadata(metadataValidForImport, index);
            }

            @Override
            public void handleFeatureCat(Element featureCat, int index) throws Exception {
                if (featureCat != null && Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Collecting feature catalog:\n" + Xml.getString((Element)featureCat)));
                }
                fc.add(index, featureCat);
            }

            @Override
            public void handleInfo(Element info, int index) throws Exception {
                Element privileges;
                Element metadata;
                String schema;
                String uuid = null;
                String createDate = null;
                String changeDate = null;
                String sourceName = null;
                Map sourceTranslations = Maps.newHashMap();
                String rating = null;
                String popularity = null;
                Element categs = null;
                if (!style.equals("_none_")) {
                    FilePathChecker.verify((String)style);
                    GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)this.val$applicationContext.getBean(GeonetworkDataDirectory.class);
                    Path stylePath = dataDirectory.getWebappDir().resolve("xsl/conversion/import");
                    String[] xsltPath = stylePath.resolve(style + ".xsl");
                    if (Files.exists((Path)xsltPath, new LinkOption[0])) {
                        md.add(index, Xml.transform((Element)((Element)md.get(index)), (Path)xsltPath));
                    } else {
                        throw new Exception(String.format("XSL transformation '%s' not found.", style));
                    }
                }
                if ((schema = dm.autodetectSchema(metadata = (Element)md.get(index), null)) == null) {
                    throw new Exception("Unknown schema");
                }
                if (info.getChildren().size() == 0) {
                    if (this.val$category != null) {
                        categs = new Element("categories");
                        for (String c : this.val$category) {
                            categs.addContent((Content)new Element("category").setAttribute("name", c));
                        }
                    }
                    privileges = new Element("group");
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "view"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "editing"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "download"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "notify"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "dynamic"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "featured"));
                    if (this.val$isTemplate == MetadataType.METADATA) {
                        uuid = dm.extractUUID(schema, (Element)md.get(index));
                    } else if (this.val$isTemplate == MetadataType.SUB_TEMPLATE) {
                        uuid = ((Element)md.get(index)).getAttributeValue("uuid");
                    } else if (this.val$isTemplate == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
                        uuid = ((Element)md.get(index)).getAttributeValue("uuid");
                    }
                } else {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("Collecting info file:\n" + Xml.getString((Element)info)));
                    }
                    categs = info.getChild("categories");
                    privileges = info.getChild("privileges");
                    Element general = info.getChild("general");
                    uuid = general.getChildText("uuid");
                    createDate = general.getChildText("createDate");
                    changeDate = general.getChildText("changeDate");
                    if (this.val$assign) {
                        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                            Log.debug((String)"geonetwork.mef", (Object)"Assign to local catalog");
                        }
                    } else {
                        sourceName = general.getChildText("siteName");
                        sourceTranslations = Localized.translationXmlToLangMap((List)general.getChildren("siteTranslations"));
                        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                            Log.debug((String)"geonetwork.mef", (Object)("Assign to catalog: " + this.val$source));
                        }
                    }
                    rating = general.getChildText("rating");
                    popularity = general.getChildText("popularity");
                }
                if (schema.startsWith("iso19139")) {
                    MetadataResourceDatabaseMigration.updateMetadataResourcesLink(metadata, null, this.val$sm);
                }
                if (this.val$validate) {
                    Integer groupIdVal = null;
                    if (StringUtils.isNotEmpty((String)this.val$groupId)) {
                        groupIdVal = Integer.parseInt(this.val$groupId);
                    }
                    DataManager.validateExternalMetadata(schema, metadata, this.val$context, groupIdVal);
                }
                try {
                    Importer.importRecord(uuid, this.val$uuidAction, md, schema, index, this.val$source, sourceName, sourceTranslations, this.val$context, this.val$metadataIdMap, createDate, changeDate, this.val$groupId, this.val$isTemplate);
                }
                catch (Exception e) {
                    throw new Exception("Failed to import metadata with uuid '" + uuid + "'. " + e.getLocalizedMessage(), e);
                }
                if (fc.size() != 0 && fc.get(index) != null) {
                    uuid = UUID.randomUUID().toString();
                    fc.add(index, dm.setUUID("iso19110", uuid, (Element)fc.get(index)));
                    int userid = this.val$context.getUserSession().getUserIdAsInt();
                    String group = null;
                    String docType = null;
                    Object title = null;
                    String category = null;
                    boolean ufo = false;
                    boolean indexImmediate = false;
                    String fcId = dm.insertMetadata(this.val$context, "iso19110", (Element)fc.get(index), uuid, userid, group, this.val$source, this.val$isTemplate.codeString, docType, category, createDate, changeDate, ufo, indexImmediate);
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("Adding Feature catalog with uuid: " + uuid));
                    }
                    String mdId = (String)this.val$metadataIdMap.get(index);
                    MetadataRelationRepository relationRepository = this.val$context.getBean(MetadataRelationRepository.class);
                    MetadataRelation relation = new MetadataRelation();
                    relation.setId(new MetadataRelationId(Integer.valueOf(mdId), Integer.valueOf(fcId)));
                    relationRepository.save((Object)relation);
                    this.val$metadataIdMap.add(fcId);
                }
                final int iMetadataId = Integer.valueOf((String)this.val$metadataIdMap.get(index));
                final String finalPopularity = popularity;
                final String finalRating = rating;
                final Element finalCategs = categs;
                final String finalGroupId = this.val$groupId;
                this.val$context.getBean(IMetadataManager.class).update(iMetadataId, (Updater<? extends AbstractMetadata>)new Updater<Metadata>(){

                    public void apply(@Nonnull Metadata metadata) {
                        MetadataDataInfo dataInfo = metadata.getDataInfo();
                        if (finalPopularity != null) {
                            dataInfo.setPopularity(Integer.valueOf(finalPopularity).intValue());
                        }
                        if (finalRating != null) {
                            dataInfo.setRating(Integer.valueOf(finalRating).intValue());
                        }
                        dataInfo.setType(val$isTemplate);
                        metadata.getHarvestInfo().setHarvested(false);
                        Importer.addCategoriesToMetadata((AbstractMetadata)metadata, finalCategs, val$context);
                        if (finalGroupId == null || finalGroupId.equals("")) {
                            Group ownerGroup = Importer.addPrivileges(val$context, dm, iMetadataId, privileges);
                            if (ownerGroup != null) {
                                metadata.getSourceInfo().setGroupOwner(Integer.valueOf(ownerGroup.getId()));
                            }
                        } else {
                            OperationAllowedRepository allowedRepository = val$context.getBean(OperationAllowedRepository.class);
                            Set allowedSet = Importer.addOperations(val$context, dm, privileges, iMetadataId, Integer.valueOf(finalGroupId));
                            allowedRepository.save((Iterable)allowedSet);
                        }
                    }
                });
                dm.indexMetadata((String)this.val$metadataIdMap.get(index), true, null);
            }

            @Override
            public void handlePublicFile(String file, String changeDate, InputStream is, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Adding public file with name=" + file));
                }
                Importer.saveFile(this.val$context, (String)this.val$metadataIdMap.get(index), MetadataResourceVisibility.PUBLIC, file, changeDate, is);
            }

            @Override
            public void handlePrivateFile(String file, String changeDate, InputStream is, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Adding private file with name=" + file));
                }
                Importer.saveFile(this.val$context, (String)this.val$metadataIdMap.get(index), MetadataResourceVisibility.PRIVATE, file, changeDate, is);
            }
        });
        return metadataIdMap;
    }

    public static void addCategoriesToMetadata(AbstractMetadata metadata, Element finalCategs, ServiceContext context) {
        if (finalCategs != null) {
            MetadataCategoryRepository categoryRepository = context.getBean(MetadataCategoryRepository.class);
            for (Object cat : finalCategs.getChildren()) {
                Element categoryEl = (Element)cat;
                String catName = categoryEl.getAttributeValue("name");
                MetadataCategory oneByName = categoryRepository.findOneByName(catName);
                if (oneByName == null) {
                    if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                    Log.debug((String)"geonetwork.mef", (Object)(" - Skipping non-existent category : " + catName));
                    continue;
                }
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)(" - Setting category : " + catName));
                }
                metadata.getCategories().add(oneByName);
            }
        }
    }

    public static void importRecord(String uuid, MEFLib.UuidAction uuidAction, List<Element> md, String schema, int index, String source, String sourceName, Map<String, String> sourceTranslations, ServiceContext context, List<String> id, String createDate, String changeDate, String groupId, MetadataType isTemplate) throws Exception {
        IMetadataManager metadataManager;
        DataManager dm;
        block10: {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            dm = gc.getBean(DataManager.class);
            metadataManager = gc.getBean(IMetadataManager.class);
            if (uuid == null || uuid.equals("") || uuidAction == MEFLib.UuidAction.GENERATEUUID) {
                String newuuid = UUID.randomUUID().toString();
                source = null;
                Log.debug((String)"geonetwork.mef", (Object)("Replacing UUID " + uuid + " with " + newuuid));
                uuid = newuuid;
                md.add(index, dm.setUUID(schema, uuid, md.get(index)));
            } else {
                if (sourceName == null) {
                    sourceName = "???";
                }
                if (source == null || source.trim().length() == 0) {
                    throw new Exception("Missing siteId parameter from info.xml file");
                }
                SourceRepository sourceRepository = context.getBean(SourceRepository.class);
                Source sourceObject = sourceRepository.findOneByUuid(source);
                if (sourceObject == null || !source.equals(gc.getBean(SettingManager.class).getSiteId()) && SourceType.harvester != sourceObject.getType()) {
                    Source source1 = new Source(source, sourceName, sourceTranslations, SourceType.externalportal);
                    context.getBean(SourceRepository.class).save((Object)source1);
                }
            }
            try {
                if (!dm.existsMetadataUuid(uuid) || uuidAction == MEFLib.UuidAction.NOTHING) break block10;
                if (dm.getAccessManager().canEdit(context, dm.getMetadataId(uuid))) {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("Deleting existing metadata with UUID : " + uuid));
                    }
                    metadataManager.deleteMetadata(context, dm.getMetadataId(uuid));
                    metadataManager.flush();
                    break block10;
                }
                throw new UnAuthorizedException("User has no privilege to replace existing metadata", null);
            }
            catch (Exception e) {
                throw new Exception(" Existing metadata with UUID " + uuid + " could not be deleted. Error is: " + e.getMessage());
            }
        }
        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
            Log.debug((String)"geonetwork.mef", (Object)("Adding metadata with uuid:" + uuid));
        }
        int userid = context.getUserSession().getUserIdAsInt();
        String docType = null;
        String category = null;
        boolean ufo = false;
        boolean indexImmediate = false;
        String metadataId = metadataManager.insertMetadata(context, schema, md.get(index), uuid, userid, groupId, source, isTemplate.codeString, docType, category, createDate, changeDate, ufo, indexImmediate);
        dm.activateWorkflowIfConfigured(context, metadataId, groupId);
        id.add(index, metadataId);
    }

    private static void saveFile(ServiceContext context, String id, MetadataResourceVisibility access, String file, String changeDate, InputStream is) throws Exception {
        Store store = context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        String metadataUuid = metadataUtils.getMetadataUuid(id);
        assert (metadataUuid != null);
        store.putResource(context, metadataUuid, file, is, new ISODate(changeDate).toDate(), access, true);
    }

    private static Group addPrivileges(ServiceContext context, DataManager dm, int metadataId, Element privil) {
        GroupRepository groupRepository = context.getBean(GroupRepository.class);
        OperationAllowedRepository allowedRepository = context.getBean(OperationAllowedRepository.class);
        List list = privil.getChildren("group");
        Group owner = null;
        HashSet<OperationAllowed> opAllowedToAdd = new HashSet<OperationAllowed>();
        ArrayList<Group> groupsToAdd = new ArrayList<Group>();
        for (Element group : list) {
            String grpName = group.getAttributeValue("name");
            boolean groupOwner = group.getAttributeValue("groupOwner") != null;
            Group groupEntity = groupRepository.findByName(grpName);
            if (groupEntity == null) {
                if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                Log.debug((String)"geonetwork.mef", (Object)(" - Skipping non-existent group : " + grpName));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)(" - Setting privileges for group : " + grpName));
            }
            groupsToAdd.add(groupEntity);
            opAllowedToAdd.addAll(Importer.addOperations(context, dm, group, metadataId, groupEntity.getId()));
            if (!groupOwner) continue;
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)(grpName + " set as group Owner "));
            }
            owner = groupEntity;
        }
        allowedRepository.save(opAllowedToAdd);
        return owner;
    }

    private static Set<OperationAllowed> addOperations(ServiceContext context, DataManager dm, Element group, int metadataId, int grpId) {
        List operations = group.getChildren("operation");
        HashSet<OperationAllowed> toAdd = new HashSet<OperationAllowed>();
        for (Element operation : operations) {
            Optional<OperationAllowed> opAllowed;
            String opName = operation.getAttributeValue("name");
            int opId = dm.getAccessManager().getPrivilegeId(opName);
            if (opId == -1) {
                if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                Log.debug((String)"geonetwork.mef", (Object)("   Skipping --> " + opName));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)("   Adding --> " + opName));
            }
            if (!(opAllowed = dm.getOperationAllowedToAdd(context, metadataId, grpId, opId)).isPresent()) continue;
            toAdd.add((OperationAllowed)opAllowed.get());
        }
        return toAdd;
    }
}

