/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.draft;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.EntityNotFoundException;
import jeeves.server.context.ServiceContext;
import org.eclipse.jetty.io.RuntimeIOException;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataHarvestInfo;
import org.fao.geonet.domain.MetadataRatingByIp;
import org.fao.geonet.domain.MetadataRatingByIpId;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatusId;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.kernel.datamanager.draft.DraftMetadataManager;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.MetadataRatingByIpRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SimpleMetadata;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

public class DraftMetadataUtils
extends BaseMetadataUtils {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private IMetadataOperations metadataOperations;
    @Autowired
    private IMetadataStatus metadataStatus;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private StatusValueRepository statusValueRepository;
    @Autowired
    private MetadataStatusRepository metadataStatusRepository;
    @Autowired
    private MetadataRatingByIpRepository metadataRatingByIpRepository;
    @Autowired
    private MetadataValidationRepository metadataValidationRepository;
    @Autowired
    private SearchManager searchManager;
    @Autowired
    private AccessManager am;
    @Autowired
    IMetadataUtils metadataUtils;
    private ServiceContext context;

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        this.context = context;
        super.init(context, force);
    }

    @Override
    public void setTemplateExt(int id, final MetadataType metadataType) throws Exception {
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(id))) {
            this.metadataDraftRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<MetadataDraft>(){

                public void apply(@Nonnull MetadataDraft metadata) {
                    MetadataDataInfo dataInfo = metadata.getDataInfo();
                    dataInfo.setType(metadataType);
                }
            });
        } else {
            super.setTemplateExt(id, metadataType);
        }
    }

    @Override
    public void setSubtemplateTypeAndTitleExt(int id, final String title) throws Exception {
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(id))) {
            this.metadataDraftRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<MetadataDraft>(){

                public void apply(@Nonnull MetadataDraft metadata) {
                    MetadataDataInfo dataInfo = metadata.getDataInfo();
                    dataInfo.setType(MetadataType.SUB_TEMPLATE);
                    if (title != null) {
                        dataInfo.setTitle(title);
                    }
                }
            });
        } else {
            super.setSubtemplateTypeAndTitleExt(id, title);
        }
    }

    @Override
    public void setHarvestedExt(int id, final String harvestUuid, final Optional<String> harvestUri) throws Exception {
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(id))) {
            this.metadataDraftRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<MetadataDraft>(){

                public void apply(MetadataDraft metadata) {
                    MetadataHarvestInfo harvestInfo = metadata.getHarvestInfo();
                    harvestInfo.setUuid(harvestUuid);
                    harvestInfo.setHarvested(harvestUuid != null);
                    harvestInfo.setUri((String)harvestUri.orNull());
                }
            });
        } else {
            super.setHarvestedExt(id, harvestUuid, harvestUri);
        }
    }

    @Override
    public void updateDisplayOrder(String idString, final String displayOrder) throws Exception {
        Integer id = Integer.valueOf(idString);
        if (this.metadataDraftRepository.exists((Serializable)id)) {
            this.metadataDraftRepository.update((Serializable)id, (Updater)new Updater<MetadataDraft>(){

                public void apply(MetadataDraft entity) {
                    entity.getDataInfo().setDisplayOrder(Integer.valueOf(Integer.parseInt(displayOrder)));
                }
            });
        } else {
            super.updateDisplayOrder(idString, displayOrder);
        }
    }

    @Override
    public int rateMetadata(int metadataId, String ipAddress, int rating) throws Exception {
        MetadataRatingByIp ratingEntity = new MetadataRatingByIp();
        ratingEntity.setRating(rating);
        ratingEntity.setId(new MetadataRatingByIpId(metadataId, ipAddress));
        this.ratingByIpRepository.save((Object)ratingEntity);
        final int newRating = this.ratingByIpRepository.averageRating(metadataId);
        if (!this.metadataDraftRepository.exists((Serializable)Integer.valueOf(metadataId))) {
            return super.rateMetadata(metadataId, ipAddress, rating);
        }
        this.metadataDraftRepository.update((Serializable)Integer.valueOf(metadataId), (Updater)new Updater<MetadataDraft>(){

            public void apply(MetadataDraft entity) {
                entity.getDataInfo().setRating(newRating);
            }
        });
        return rating;
    }

    @Override
    public long count(Specification<? extends AbstractMetadata> specs) {
        long tmp = 0L;
        try {
            tmp += super.count(specs);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            tmp += this.metadataDraftRepository.count(specs);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return tmp;
    }

    @Override
    public long count() {
        return super.count() + this.metadataDraftRepository.count();
    }

    @Override
    public AbstractMetadata findOne(int id) {
        if (super.exists(id)) {
            return super.findOne(id);
        }
        return (AbstractMetadata)this.metadataDraftRepository.findOne((Serializable)Integer.valueOf(id));
    }

    @Override
    public boolean existsMetadataUuid(String uuid) throws Exception {
        return super.existsMetadataUuid(uuid) || !this.findAllIdsBy((Specification<? extends AbstractMetadata>)MetadataSpecs.hasMetadataUuid((String)uuid)).isEmpty();
    }

    @Override
    public AbstractMetadata findOneByUuid(String uuid) {
        AbstractMetadata md = super.findOneByUuid(uuid);
        try {
            if (md != null && this.am.canEdit(this.context, Integer.toString(md.getId()))) {
                MetadataDraft tmp = this.metadataDraftRepository.findOneByUuid(uuid);
                if (tmp != null) {
                    md = tmp;
                }
            } else if (md == null) {
                md = this.metadataDraftRepository.findOneByUuid(uuid);
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.datamanager", (Object)e, (Throwable)e);
        }
        return md;
    }

    @Override
    public List<? extends AbstractMetadata> findAllByUuid(String uuid) {
        LinkedList<? extends AbstractMetadata> res = new LinkedList<AbstractMetadata>();
        res.addAll(super.findAllByUuid(uuid));
        res.addAll(this.metadataDraftRepository.findAllByUuid(uuid));
        return res;
    }

    @Override
    public AbstractMetadata findOne(Specification<? extends AbstractMetadata> spec) {
        AbstractMetadata md = null;
        try {
            md = super.findOne(spec);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (md == null) {
            try {
                md = (AbstractMetadata)this.metadataDraftRepository.findOne(spec);
            }
            catch (ClassCastException t) {
                throw new ClassCastException("Unknown AbstractMetadata subtype: " + spec.getClass().getName());
            }
        }
        return md;
    }

    @Override
    public AbstractMetadata findOne(String id) {
        AbstractMetadata md = super.findOne(id);
        if (md == null) {
            md = this.metadataDraftRepository.findOne(id);
        }
        return md;
    }

    @Override
    public List<? extends AbstractMetadata> findAllByHarvestInfo_Uuid(String uuid) {
        LinkedList<? extends AbstractMetadata> list = new LinkedList<AbstractMetadata>();
        list.addAll(this.metadataDraftRepository.findAllByHarvestInfo_Uuid(uuid));
        list.addAll(super.findAllByHarvestInfo_Uuid(uuid));
        return list;
    }

    @Override
    public Iterable<? extends AbstractMetadata> findAll(Set<Integer> keySet) {
        LinkedList<AbstractMetadata> list = new LinkedList<AbstractMetadata>();
        for (AbstractMetadata abstractMetadata : super.findAll(keySet)) {
            list.add(abstractMetadata);
        }
        list.addAll(this.metadataDraftRepository.findAll(keySet));
        return list;
    }

    @Override
    public List<? extends AbstractMetadata> findAll(Specification<? extends AbstractMetadata> specs) {
        LinkedList<? extends AbstractMetadata> list = new LinkedList<AbstractMetadata>();
        try {
            list.addAll(super.findAll(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            list.addAll(this.metadataDraftRepository.findAll(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public List<SimpleMetadata> findAllSimple(String harvestUuid) {
        List<SimpleMetadata> list = super.findAllSimple(harvestUuid);
        list.addAll(this.metadataDraftRepository.findAllSimple(harvestUuid));
        return list;
    }

    @Override
    public boolean exists(Integer iId) {
        return super.exists(iId) || this.metadataDraftRepository.exists((Serializable)iId);
    }

    @Override
    public Page<Pair<Integer, ISODate>> findAllIdsAndChangeDates(Pageable pageable) {
        LinkedList list = new LinkedList();
        list.addAll(super.findAllIdsAndChangeDates(pageable).getContent());
        list.addAll(this.metadataDraftRepository.findAllIdsAndChangeDates(pageable).getContent());
        PageImpl res = new PageImpl(list, pageable, (long)list.size());
        return res;
    }

    @Override
    public Map<Integer, MetadataSourceInfo> findAllSourceInfo(Specification<? extends AbstractMetadata> spec) {
        LinkedHashMap<Integer, MetadataSourceInfo> map = new LinkedHashMap<Integer, MetadataSourceInfo>();
        try {
            map.putAll(super.findAllSourceInfo(spec));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            map.putAll(this.metadataDraftRepository.findAllSourceInfo(spec));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return map;
    }

    @Override
    public List<Integer> findAllIdsBy(Specification<? extends AbstractMetadata> specs) {
        LinkedList<Integer> res = new LinkedList<Integer>();
        try {
            res.addAll(super.findAllIdsBy(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            res.addAll(this.metadataDraftRepository.findAllIdsBy(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public Integer startEditingSession(ServiceContext context, String id) throws Exception {
        AbstractMetadata md = this.findOne(Integer.valueOf(id));
        if (md == null) {
            throw new EntityNotFoundException("We couldn't find the metadata to edit");
        }
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (this.metadataDraftRepository.findOneByUuid(md.getUuid()) != null) {
            id = Integer.toString(this.metadataDraftRepository.findOneByUuid(md.getUuid()).getId());
            Log.trace((String)"geonetwork.datamanager", (Object)("Editing draft with id " + id));
        } else if (isMdWorkflowEnable && context.getBean(IMetadataManager.class) instanceof DraftMetadataManager && this.metadataStatus.getCurrentStatus(Integer.valueOf(id)).equals("2")) {
            id = this.createDraft(context, id, md);
            Log.trace((String)"geonetwork.datamanager", (Object)("Creating draft with id " + id + " to edit."));
        }
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)("Editing record with id = " + id));
            Log.trace((String)"geonetwork.datamanager", (Object)("Status of record: " + this.metadataStatus.getCurrentStatus(Integer.valueOf(id))));
        }
        return super.startEditingSession(context, id);
    }

    private String createDraft(ServiceContext context, String id, AbstractMetadata md) throws Exception, IOException, JDOMException {
        String parentUuid = null;
        String groupOwner = null;
        String source = null;
        Integer owner = 1;
        if (md.getSourceInfo() != null) {
            if (md.getSourceInfo().getSourceId() != null) {
                source = md.getSourceInfo().getSourceId().toString();
            }
            if (md.getSourceInfo().getGroupOwner() != null) {
                groupOwner = md.getSourceInfo().getGroupOwner().toString();
            }
            owner = md.getSourceInfo().getOwner();
        }
        id = this.createDraft(context, id, groupOwner, source, owner, parentUuid, md.getDataInfo().getType().codeString, md.getUuid());
        return id;
    }

    protected String createDraft(ServiceContext context, String templateId, String groupOwner, String source, int owner, String parentUuid, String isTemplate, String uuid) throws Exception {
        Group group;
        Log.trace((String)"geonetwork.datamanager", (Object)("createDraft(" + templateId + "," + groupOwner + "," + source + "," + owner + "," + parentUuid + "," + isTemplate + "," + uuid + ")"));
        Metadata templateMetadata = (Metadata)this.getMetadataRepository().findOne(templateId);
        if (templateMetadata == null) {
            throw new IllegalArgumentException("Template id not found : " + templateId);
        }
        String schema = templateMetadata.getDataInfo().getSchemaId();
        String data = templateMetadata.getData();
        Element xml = Xml.loadString((String)data, (boolean)false);
        if (templateMetadata.getDataInfo().getType() == MetadataType.METADATA) {
            xml = this.metadataManager.updateFixedInfo(schema, (Optional<Integer>)Optional.absent(), uuid, xml, parentUuid, UpdateDatestamp.NO, context);
        }
        MetadataDraft newMetadata = new MetadataDraft();
        newMetadata.setUuid(uuid);
        newMetadata.setApprovedVersion(templateMetadata);
        newMetadata.getDataInfo().setChangeDate(new ISODate()).setCreateDate(new ISODate()).setSchemaId(schema).setType(MetadataType.lookup((String)isTemplate));
        if (groupOwner != null) {
            newMetadata.getSourceInfo().setGroupOwner(Integer.valueOf(groupOwner));
        }
        newMetadata.getSourceInfo().setOwner(Integer.valueOf(owner));
        if (source != null) {
            newMetadata.getSourceInfo().setSourceId(source);
        }
        if (groupOwner != null && (group = (Group)this.groupRepository.findOne((Serializable)Integer.valueOf(groupOwner))).getDefaultCategory() != null) {
            newMetadata.getCategories().add(group.getDefaultCategory());
        }
        for (Object mc : templateMetadata.getCategories()) {
            newMetadata.getCategories().add(mc);
        }
        try {
            newMetadata = (MetadataDraft)this.metadataManager.insertMetadata(context, (AbstractMetadata)newMetadata, xml, false, true, true, UpdateDatestamp.YES, false, true);
            Integer finalId = newMetadata.getId();
            this.cloneFiles((AbstractMetadata)templateMetadata, (AbstractMetadata)newMetadata);
            this.metadataOperations.deleteMetadataOper(String.valueOf(finalId), false);
            for (OperationAllowed operationAllowed : this.metadataOperations.getAllOperations(templateMetadata.getId())) {
                if (operationAllowed.getId().getOperationId() == ReservedOperation.editing.getId() || groupOwner != null && operationAllowed.getId().getGroupId() == Integer.parseInt(groupOwner)) {
                    Log.trace((String)"geonetwork.datamanager", (Object)("Assign operation: " + operationAllowed));
                    this.metadataOperations.forceSetOperation(context, finalId, operationAllowed.getId().getGroupId(), operationAllowed.getId().getOperationId());
                    continue;
                }
                Log.trace((String)"geonetwork.datamanager", (Object)("Skipping operation: " + operationAllowed));
            }
            List validations = this.metadataValidationRepository.findAllById_MetadataId(templateMetadata.getId());
            for (MetadataValidation mv : validations) {
                MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(finalId.intValue(), mv.getId().getValidationType())).setStatus(mv.getStatus()).setRequired(mv.isRequired()).setValid(mv.isValid()).setValidationDate(mv.getValidationDate()).setNumTests(mv.getNumTests()).setNumFailures(mv.getNumFailures()).setReportUrl(mv.getReportUrl()).setReportContent(mv.getReportContent());
                this.metadataValidationRepository.save((Object)metadataValidation);
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(finalId);
            StatusActionsFactory saf = context.getBean(StatusActionsFactory.class);
            StatusActions sa = saf.createStatusActions(context);
            int author = context.getUserSession().getUserIdAsInt();
            Integer status = Integer.valueOf("1");
            StatusValue statusValue = (StatusValue)this.statusValueRepository.findOne((Serializable)status);
            for (Integer mdId : hashSet) {
                MetadataStatus metadataStatus = new MetadataStatus();
                MetadataStatusId mdStatusId = new MetadataStatusId().setStatusId(status.intValue()).setMetadataId(mdId.intValue()).setChangeDate(new ISODate()).setUserId(author);
                metadataStatus.setId(mdStatusId);
                metadataStatus.setStatusValue(statusValue);
                metadataStatus.setChangeMessage("Editing instance created");
                ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
                listOfStatusChange.add(metadataStatus);
                sa.onStatusChange(listOfStatusChange);
            }
            return String.valueOf(finalId);
        }
        catch (Throwable t) {
            Log.error((String)"geonetwork.datamanager", (Object)"Editing instance creation failed", (Throwable)t);
            return templateId;
        }
    }

    @Override
    public void cloneFiles(AbstractMetadata original, AbstractMetadata dest) {
        try {
            StoreUtils.copyDataDir(this.context, original.getUuid(), dest.getUuid(), false);
            this.cloneStoreFileUploadRequests(original, dest);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("Failed copy of resources: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeIOException((Throwable)ex);
        }
    }

    @Override
    public void replaceFiles(AbstractMetadata original, AbstractMetadata dest) {
        try {
            boolean oldApproved = true;
            boolean newApproved = false;
            if (this.metadataUtils.isMetadataApproved(dest.getId())) {
                oldApproved = false;
                newApproved = true;
            }
            StoreUtils.replaceDataDir(this.context, original.getUuid(), dest.getUuid(), oldApproved, newApproved);
            this.cloneStoreFileUploadRequests(original, dest);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("Failed copy of resources: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeIOException((Throwable)ex);
        }
    }

    @Override
    public void cancelEditingSession(ServiceContext context, String id) throws Exception {
        super.cancelEditingSession(context, id);
        int intId = Integer.parseInt(id);
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(intId)) && context.getUserSession().getProperty("metadata.editing.created.draft") == Boolean.TRUE) {
            try {
                this.metadataOperations.deleteMetadataOper(id, false);
                this.metadataRatingByIpRepository.deleteAllById_MetadataId(intId);
                this.metadataValidationRepository.deleteAllById_MetadataId(Integer.valueOf(intId));
                this.metadataStatusRepository.deleteAllById_MetadataId(Integer.valueOf(intId));
                this.xmlSerializer.delete(id, ServiceContext.get());
                this.searchManager.delete(id);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.datamanager", (Object)("Couldn't cleanup draft " + id), (Throwable)e);
            }
        }
    }

    private void cloneStoreFileUploadRequests(AbstractMetadata original, AbstractMetadata copy) {
        MetadataFileUploadRepository repo = this.context.getBean(MetadataFileUploadRepository.class);
        repo.deleteAll(MetadataFileUploadSpecs.hasMetadataId((int)copy.getId()));
        for (MetadataFileUpload mfu : repo.findAll(MetadataFileUploadSpecs.hasMetadataId((int)original.getId()))) {
            MetadataFileUpload metadataFileUpload = new MetadataFileUpload();
            metadataFileUpload.setMetadataId(copy.getId());
            metadataFileUpload.setFileName(mfu.getFileName());
            metadataFileUpload.setFileSize(mfu.getFileSize());
            metadataFileUpload.setUploadDate(mfu.getUploadDate());
            metadataFileUpload.setUserName(mfu.getUserName());
            repo.save((Object)metadataFileUpload);
        }
    }
}

