/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.datamanager.IMetadataCategory;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.Updater;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseMetadataCategory
implements IMetadataCategory {
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired(required=false)
    private SvnManager svnManager;
    @Autowired
    private MetadataCategoryRepository metadataCategoryRepository;

    @Override
    public boolean setCategory(ServiceContext context, String mdId, String categId) throws Exception {
        if (!this.getMetadataRepository().exists((Serializable)Integer.valueOf(mdId))) {
            return false;
        }
        final MetadataCategory newCategory = (MetadataCategory)this.metadataCategoryRepository.findOne((Serializable)Integer.valueOf(categId));
        final boolean[] changed = new boolean[1];
        this.getMetadataRepository().update((Serializable)Integer.valueOf(mdId), (Updater)new Updater<Metadata>(){

            public void apply(@Nonnull Metadata entity) {
                changed[0] = !entity.getMetadataCategories().contains(newCategory);
                entity.getMetadataCategories().add(newCategory);
            }
        });
        if (changed[0]) {
            if (this.getSvnManager() != null) {
                this.getSvnManager().setHistory(mdId, context);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCategorySet(String mdId, int categId) throws Exception {
        Set categories = this.getMetadataUtils().findOne(mdId).getCategories();
        for (MetadataCategory category : categories) {
            if (category.getId() != categId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetCategory(ServiceContext context, String mdId, int categId) throws Exception {
        AbstractMetadata metadata = this.getMetadataUtils().findOne(mdId);
        if (metadata == null) {
            return false;
        }
        boolean changed = false;
        for (MetadataCategory category : metadata.getCategories()) {
            if (category.getId() != categId) continue;
            changed = true;
            metadata.getCategories().remove(category);
            break;
        }
        if (changed) {
            context.getBean(IMetadataManager.class).save(metadata);
            if (this.getSvnManager() != null) {
                this.getSvnManager().setHistory(mdId + "", context);
            }
        }
        return changed;
    }

    @Override
    public Collection<MetadataCategory> getCategories(String mdId) throws Exception {
        AbstractMetadata metadata = this.getMetadataUtils().findOne(mdId);
        if (metadata == null) {
            throw new IllegalArgumentException("No metadata found with id: " + mdId);
        }
        return metadata.getCategories();
    }

    protected SvnManager getSvnManager() {
        return this.svnManager;
    }

    protected IMetadataUtils getMetadataUtils() {
        return this.metadataUtils;
    }

    protected MetadataCategoryRepository getMetadataCategoryRepository() {
        return this.metadataCategoryRepository;
    }

    protected MetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }
}

