/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.sources.http;

import java.net.MalformedURLException;
import java.nio.file.Path;
import javax.servlet.ServletContext;
import org.fao.geonet.utils.IO;

public class ServletPathFinder {
    private final String _baseUrl;
    private final Path _configPath;
    private final Path _appPath;

    public ServletPathFinder(ServletContext servletContext) {
        Path appPath = IO.toPath((String)servletContext.getRealPath("/xsl"), (String[])new String[0]).getParent();
        String baseUrl = "";
        try {
            baseUrl = servletContext.getContextPath();
        }
        catch (NoSuchMethodError ex) {
            try {
                String resource = servletContext.getResource("/").getPath();
                baseUrl = resource.substring(resource.indexOf(47, 1), resource.length() - 1);
            }
            catch (MalformedURLException e) {
                baseUrl = servletContext.getServletContextName();
            }
        }
        String configPathString = servletContext.getRealPath("/WEB-INF/config.xml");
        this._configPath = configPathString == null ? appPath.resolve("WEB-INF") : IO.toPath((String)configPathString, (String[])new String[0]).getParent();
        this._baseUrl = baseUrl;
        this._appPath = appPath;
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public Path getConfigPath() {
        return this._configPath;
    }

    public Path getAppPath() {
        return this._appPath;
    }
}

