/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import jeeves.server.sources.ServiceRequest;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.StringBufferOutputStream;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LocalServiceRequest
extends ServiceRequest {
    private static final Element NULL_PARAMS = new Element("request");
    private StringBuffer outputBuffer = new StringBuffer(128);

    public static LocalServiceRequest create(String url) throws Exception {
        return LocalServiceRequest.create(url, null);
    }

    public static LocalServiceRequest create(String url, Element params) throws Exception {
        LocalServiceRequest srvReq = new LocalServiceRequest();
        srvReq.setDebug(true);
        srvReq.setLanguage(LocalServiceRequest.extractLanguage(url));
        srvReq.setService(LocalServiceRequest.extractService(url));
        srvReq.setAddress("127.0.0.1");
        srvReq.setOutputStream((OutputStream)new StringBufferOutputStream(srvReq.outputBuffer));
        srvReq.setInputMethod(ServiceRequest.InputMethod.XML);
        srvReq.setOutputMethod(ServiceRequest.OutputMethod.XML);
        if (params == null) {
            params = LocalServiceRequest.extractParams(url);
        }
        srvReq.setParams(params);
        return srvReq;
    }

    private static String extractLanguage(String url) {
        if (url == null) {
            return null;
        }
        int indexOfParams = url.indexOf(63);
        if (indexOfParams > -1) {
            url = url.substring(0, indexOfParams);
        }
        if (url.contains("://")) {
            url = url.substring(url.indexOf("://") + 3);
        } else if (url.startsWith("/")) {
            url = url.substring(1);
        }
        int pos = url.indexOf(47);
        if (pos == -1) {
            return null;
        }
        return url.substring(0, pos);
    }

    private static String extractService(String url) {
        int pos;
        if (url == null) {
            return null;
        }
        if ((url = url.split("\\?")[0]).endsWith("!")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((pos = url.lastIndexOf(47)) == -1) {
            return url;
        }
        return url.substring(pos + 1);
    }

    private static Element extractParams(String url) {
        if (url == null) {
            return NULL_PARAMS;
        }
        String[] urlParts = url.split("\\?");
        if (urlParts.length != 2) {
            return NULL_PARAMS;
        }
        String queryPart = urlParts[1];
        String[] nvPairs = queryPart.split("\\&");
        Element result = new Element("request");
        for (int i = 0; i < nvPairs.length; ++i) {
            String[] nvPair = nvPairs[i].split("\\=");
            String name = nvPair[0];
            String value = nvPair.length == 2 ? nvPair[1] : "";
            if (name.startsWith("@")) {
                name = name.substring(name.indexOf(64) + 1);
                result.setAttribute(name, value);
                continue;
            }
            Element param = new Element(name);
            try {
                param.setText(URLDecoder.decode(value, Constants.ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                param.setText(value);
            }
            result.addContent((Content)param);
        }
        return result;
    }

    @Override
    public void beginStream(String contentType, boolean cache) {
        this.beginStream(contentType, -1, null, cache);
    }

    @Override
    public void beginStream(String contentType, int contentLength, String contentDisposition, boolean cache) {
    }

    @Override
    public void endStream() throws IOException {
    }

    public String getResultString() {
        String string = this.outputBuffer.toString().trim();
        if (string.matches("<\\?xml\\s+version=[^>]+\\s+encoding=[^>]+\\?>")) {
            return "";
        }
        return string;
    }

    public Element getResult() throws IOException, JDOMException {
        String resultString = this.getResultString();
        if (resultString.trim().isEmpty()) {
            return null;
        }
        return Xml.loadString((String)resultString, (boolean)false);
    }

    public String toString() {
        return this.language + "/" + this.service + "?" + this.toString(this.params);
    }

    private String toString(Element params) {
        StringBuilder paramsString = new StringBuilder();
        for (Element el : params.getChildren()) {
            if (paramsString.length() > 0) {
                paramsString.append("&");
            }
            paramsString.append(el.getName()).append('=').append(el.getTextTrim());
        }
        return paramsString.toString();
    }
}

