/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.marc4j.marc.DataField;
import org.marc4j.marc.IllegalAddException;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.SubfieldImpl;
import org.marc4j.marc.impl.VariableFieldImpl;

public class DataFieldImpl
extends VariableFieldImpl
implements DataField {
    private Long id;
    private char ind1;
    private char ind2;
    private List subfields = new ArrayList();

    public DataFieldImpl() {
    }

    public DataFieldImpl(String tag, char ind1, char ind2) {
        this();
        this.setTag(tag);
        this.setIndicator1(ind1);
        this.setIndicator2(ind2);
    }

    public void setIndicator1(char ind1) {
        this.ind1 = ind1;
    }

    public char getIndicator1() {
        return this.ind1;
    }

    public void setIndicator2(char ind2) {
        this.ind2 = ind2;
    }

    public char getIndicator2() {
        return this.ind2;
    }

    public void addSubfield(Subfield subfield) {
        if (!(subfield instanceof SubfieldImpl)) {
            throw new IllegalAddException("Subfield");
        }
        this.subfields.add(subfield);
    }

    public void addSubfield(int index, Subfield subfield) {
        this.subfields.add(index, subfield);
    }

    public void removeSubfield(Subfield subfield) {
        this.subfields.remove(subfield);
    }

    public List getSubfields() {
        return this.subfields;
    }

    public List getSubfields(char code) {
        ArrayList<Subfield> retSubfields = new ArrayList<Subfield>();
        Iterator i = this.subfields.iterator();
        while (i.hasNext()) {
            Subfield sf = (Subfield)i.next();
            if (sf.getCode() != code) continue;
            retSubfields.add(sf);
        }
        return retSubfields;
    }

    public Subfield getSubfield(char code) {
        Iterator i = this.subfields.iterator();
        while (i.hasNext()) {
            Subfield sf = (Subfield)i.next();
            if (sf.getCode() != code) continue;
            return sf;
        }
        return null;
    }

    public boolean find(String pattern) {
        Iterator i = this.subfields.iterator();
        while (i.hasNext()) {
            Subfield sf = (Subfield)i.next();
            if (!sf.find(pattern)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(' ');
        sb.append(this.getIndicator1());
        sb.append(this.getIndicator2());
        Iterator i = this.getSubfields().iterator();
        while (i.hasNext()) {
            Subfield sf = (Subfield)i.next();
            sb.append(sf.toString());
        }
        return sb.toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

