/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.itextpdf.text.DocumentException;
import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.output.AbstractImageFormat;
import org.mapfish.print.output.InMemoryJaiMosaicOutputFactory;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.PrintParams;
import org.mapfish.print.utils.PJsonObject;

public class FileCachingJaiMosaicOutputFactory
extends InMemoryJaiMosaicOutputFactory {
    @Override
    public OutputFormat create(String format) {
        return new ImageOutputScalable(format);
    }

    @Override
    public String enablementStatus() {
        if (super.enablementStatus() != null) {
            return super.enablementStatus();
        }
        if (!this.formats().contains("TIFF")) {
            return "TIFF not supported by ImageIO";
        }
        return null;
    }

    static class ImageInfo {
        final File imageFile;
        final int width;
        final int height;

        ImageInfo(File imageFile, int width, int height) {
            this.imageFile = imageFile;
            this.width = width;
            this.height = height;
        }
    }

    public static class ImageOutputScalable
    extends AbstractImageFormat {
        public static final Logger LOGGER = Logger.getLogger(ImageOutputScalable.class);

        public ImageOutputScalable(String format) {
            super(format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderingContext print(PrintParams params) throws DocumentException {
            File tmpFile = null;
            try {
                RenderingContext context;
                tmpFile = File.createTempFile("mapfishprint", ".pdf");
                FileOutputStream tmpOut = new FileOutputStream(tmpFile);
                try {
                    context = this.doPrint(params.withOutput(tmpOut));
                }
                finally {
                    tmpOut.close();
                }
                List<ImageInfo> images = this.createImages(params.jsonSpec, tmpFile, context);
                this.drawImage(params.outputStream, images);
                RenderingContext renderingContext = context;
                return renderingContext;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (tmpFile != null) {
                    if (!tmpFile.delete()) {
                        LOGGER.warn((Object)(tmpFile + " was not able to be deleted for unknown reason.  Will try again on shutdown"));
                    }
                    tmpFile.deleteOnExit();
                }
            }
        }

        private void drawImage(OutputStream out, List<ImageInfo> images) throws IOException {
            ParameterBlock pbMosaic = new ParameterBlock();
            float height = 0.0f;
            float width = 0.0f;
            int i = 0;
            for (ImageInfo imageinfo : images) {
                ParameterBlock pb = new ParameterBlock();
                pb.add(new FileSeekableStream(imageinfo.imageFile));
                pb.add(null);
                pb.add(null);
                RenderedOp source = JAI.create((String)"TIFF", (ParameterBlock)pb);
                LOGGER.debug((Object)("Adding page image " + ++i + " bounds: [" + 0 + "," + height + " " + source.getWidth() + "," + (height + (float)source.getHeight()) + "]"));
                RenderedOp translated = this.translateImage(height, (RenderedImage)source);
                pbMosaic.addSource(translated);
                height += (float)imageinfo.height + 20.0f;
                if (!(width < (float)imageinfo.width)) continue;
                width = imageinfo.width;
            }
            RenderedOp mosaic = JAI.create((String)"mosaic", (ParameterBlock)pbMosaic);
            ImageIO.write((RenderedImage)mosaic, this.format, out);
        }

        private RenderedOp translateImage(float height, RenderedImage source) {
            ParameterBlock pbTranslate = new ParameterBlock();
            pbTranslate.addSource(source);
            pbTranslate.add(0.0f);
            pbTranslate.add(height);
            return JAI.create((String)"translate", (ParameterBlock)pbTranslate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ImageInfo> createImages(PJsonObject jsonSpec, File tmpFile, RenderingContext context) throws IOException {
            ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
            PDDocument pdf = PDDocument.load((File)tmpFile);
            try {
                PDFRenderer pdfRenderer = new PDFRenderer(pdf);
                for (PDPage page : pdf.getPages()) {
                    BufferedImage img = pdfRenderer.renderImageWithDPI(images.size(), (float)this.calculateDPI(context, jsonSpec), ImageType.RGB);
                    File file = File.createTempFile("pdfToImage", "tiff");
                    ImageIO.write((RenderedImage)img, "TIFF", file);
                    images.add(new ImageInfo(file, img.getWidth(), img.getHeight()));
                }
            }
            finally {
                pdf.close();
            }
            return images;
        }
    }
}

