/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.field;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;

public interface FieldDescription
extends ByteCodeElement {
    public TypeDescription getFieldType();

    public static class Latent
    extends AbstractFieldDescription {
        private final String fieldName;
        private final TypeDescription declaringType;
        private final TypeDescription fieldType;
        private final int modifiers;

        public Latent(String fieldName, TypeDescription declaringType, TypeDescription fieldType, int modifiers) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.declaringType = declaringType;
            this.modifiers = modifiers;
        }

        @Override
        public TypeDescription getFieldType() {
            return this.fieldType;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public String getName() {
            return this.fieldName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static class ForLoadedField
    extends AbstractFieldDescription {
        private final Field field;

        public ForLoadedField(Field field) {
            this.field = field;
        }

        @Override
        public TypeDescription getFieldType() {
            return new TypeDescription.ForLoadedType(this.field.getType());
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.field.getDeclaredAnnotations());
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.field.getDeclaringClass());
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.field.isSynthetic();
        }
    }

    public static abstract class AbstractFieldDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements FieldDescription {
        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.getName();
        }

        @Override
        public String getDescriptor() {
            return this.getFieldType().getDescriptor();
        }

        @Override
        public String getGenericSignature() {
            return null;
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.getDeclaringType().isVisibleTo(typeDescription) && this.getFieldType().isVisibleTo(typeDescription) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType()));
        }

        public boolean equals(Object other) {
            return other == this || other instanceof FieldDescription && this.getName().equals(((FieldDescription)other).getName()) && this.getDeclaringType().equals(((FieldDescription)other).getDeclaringType());
        }

        public int hashCode() {
            return this.getDeclaringType().hashCode() + 31 * this.getName().hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getModifiers() != 0) {
                stringBuilder.append(Modifier.toString(this.getModifiers())).append(" ");
            }
            stringBuilder.append(this.getFieldType().getSourceCodeName()).append(" ");
            stringBuilder.append(this.getDeclaringType().getSourceCodeName()).append(".");
            return stringBuilder.append(this.getName()).toString();
        }
    }
}

