/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import java.io.File;
import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import opendap.servlet.BadURLException;
import org.fao.geonet.utils.BinaryFile;
import org.jdom.Element;

public class Log
implements Service {
    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String logfile = params.getChildText("file").trim();
        if (logfile.startsWith("http") || logfile.startsWith("ftp") || logfile.startsWith("sftp")) {
            throw new BadURLException("This is no proxy. Stopping possible hacking attempt to url: " + logfile);
        }
        if (!logfile.endsWith(".log")) {
            throw new BadURLException("Strange suffix for this log file. Stopping possible hacking attempt to uri: " + logfile);
        }
        if (!logfile.contains("/harvester_")) {
            throw new BadURLException("This doesn't seem like a harvester log file. Stopping possible hacking attempt to uri: " + logfile);
        }
        File file = new File(logfile);
        if (!file.exists() || !file.canRead()) {
            throw new NullPointerException("Couldn't find or read the logfile. Somebody moved it? " + file.getAbsolutePath());
        }
        return BinaryFile.encode((int)200, (Path)file.toPath().toAbsolutePath().normalize(), (boolean)false).getElement();
    }
}

