/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.kernel.search.keyword.KeywordSort;
import org.fao.geonet.kernel.search.keyword.SortDirection;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
public class GetKeywords {
    @RequestMapping(value={"/{uiLang}/xml.search.keywords"})
    @ResponseBody
    public HttpEntity<byte[]> deprecatedAPI(@PathVariable String uiLang, @RequestParam(value="pNewSearch", defaultValue="true") boolean newSearch, @RequestParam(value="pMode", defaultValue="true") String mode, @RequestParam(value="pKeyword", required=false) String searchTerm, @RequestParam(value="maxResults", required=false, defaultValue="1000") String maxResults, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pLang", defaultValue="") List<String> targetLangs, @RequestParam(value="pThesauri", required=false) List<String> thesauri, @RequestParam(value="pType", required=false) String thesauriDomainName, @RequestParam(value="pTypeSearch", defaultValue="2") String typeSearch, @RequestParam(value="pUri", required=false) String keywordUriCode, @RequestParam(value="sort", required=false, defaultValue="DESC") String sort, NativeWebRequest webRequest) throws Exception {
        return this.exec(uiLang, newSearch, mode, searchTerm, maxResults, offset, targetLangs, thesauri, thesauriDomainName, typeSearch, keywordUriCode, sort, webRequest);
    }

    @RequestMapping(value={"/{uiLang}/keywords"})
    @ResponseBody
    public HttpEntity<byte[]> exec(@PathVariable String uiLang, @RequestParam(value="pNewSearch", defaultValue="true") boolean newSearch, @RequestParam(value="pMode", defaultValue="true") String mode, @RequestParam(value="pKeyword", required=false) String searchTerm, @RequestParam(value="maxResults", required=false, defaultValue="1000") String maxResults, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pLang", defaultValue="") List<String> targetLangs, @RequestParam(value="pThesauri", required=false) List<String> thesauri, @RequestParam(value="pType", required=false) String thesauriDomainName, @RequestParam(value="pTypeSearch", defaultValue="2") String typeSearch, @RequestParam(value="pUri", required=false) String keywordUriCode, @RequestParam(value="sort", required=false, defaultValue="DESC") String sort, NativeWebRequest webRequest) throws Exception {
        String contentType;
        byte[] response;
        Object[] objectArray;
        Object[] acceptHeader;
        KeywordsSearcher searcher;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ((ServiceManager)applicationContext.getBean(ServiceManager.class)).createServiceContext("keywords", uiLang, (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        Element responseXml = new Element("response");
        UserSession session = context.getUserSession();
        if (newSearch) {
            ThesaurusManager thesaurusMan = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
            if (Log.isDebugEnabled((String)"KeywordsManager")) {
                Log.debug((String)"KeywordsManager", (Object)"Creating new keywords searcher");
            }
            searcher = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
            IsoLanguagesMapper languagesMapper = (IsoLanguagesMapper)applicationContext.getBean(IsoLanguagesMapper.class);
            KeywordSearchParamsBuilder builder = this.parseBuilder(uiLang, searchTerm, maxResults, offset, targetLangs, thesauri, thesauriDomainName, typeSearch, keywordUriCode, languagesMapper);
            if (this.checkModified(webRequest, thesaurusMan, builder)) {
                return null;
            }
            if (searchTerm == null || searchTerm.trim().isEmpty()) {
                builder.setComparator(KeywordSort.defaultLabelSorter((SortDirection)SortDirection.parse((String)sort)));
            } else {
                builder.setComparator(KeywordSort.searchResultsSorter((String)searchTerm, (SortDirection)SortDirection.parse((String)sort)));
            }
            searcher.search(builder.build());
            session.setProperty("search.keywords.result", (Object)searcher);
        } else {
            searcher = (KeywordsSearcher)session.getProperty("search.keywords.result");
        }
        responseXml.addContent((Content)searcher.getXmlResults());
        if (mode != null && (mode.equals("edit") || mode.equals("consult"))) {
            responseXml.addContent((Content)new Element("thesaurus").addContent(thesauri));
            responseXml.addContent((Content)new Element("mode").addContent(mode));
        }
        if ((acceptHeader = webRequest.getHeaderValues("Accept")) != null) {
            objectArray = acceptHeader;
        } else {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "text/plain";
        }
        HashSet acceptContentType = Sets.newHashSet((Object[])objectArray);
        if (this.acceptsType(acceptContentType, "json") || "json".equals(webRequest.getParameter("_content_type"))) {
            response = Xml.getJSON((Element)responseXml).getBytes(Constants.CHARSET);
            contentType = "application/json";
        } else if (acceptContentType.isEmpty() || this.acceptsType(acceptContentType, "xml") || acceptContentType.contains("*/*") || acceptContentType.contains("text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2") || acceptContentType.contains("text/plain")) {
            response = Xml.getString((Element)responseXml).getBytes(Constants.CHARSET);
            contentType = "application/xml";
        } else {
            throw new IllegalArgumentException(acceptContentType + " is not supported");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add((Object)"Content-Type", (Object)contentType);
        headers.add((Object)"Cache-Control", (Object)"no-cache");
        return new HttpEntity((Object)response, (MultiValueMap)headers);
    }

    private boolean checkModified(NativeWebRequest webRequest, ThesaurusManager thesaurusMan, KeywordSearchParamsBuilder builder) {
        long latestLastModified = -1L;
        for (String thesName : builder.getThesauriNames()) {
            Thesaurus thesaurus = thesaurusMan.getThesaurusByName(thesName);
            if (thesaurus == null) {
                return false;
            }
            long thesLastModified = thesaurus.getLastModifiedTime().toMillis();
            if (latestLastModified >= thesLastModified) continue;
            latestLastModified = thesLastModified;
        }
        long roundedChangeDate = latestLastModified / 1000L * 1000L;
        return webRequest.checkNotModified(roundedChangeDate);
    }

    private KeywordSearchParamsBuilder parseBuilder(String uiLang, String searchTerm, String maxResults, String offset, List<String> targetLangs, List<String> thesauri, String thesauriDomainName, String typeSearch, String keywordUriCode, IsoLanguagesMapper mapper) {
        KeywordSearchParamsBuilder parsedParams = new KeywordSearchParamsBuilder(mapper).lenient(true);
        if (searchTerm != null) {
            KeywordSearchType searchType = KeywordSearchType.parseString((String)typeSearch);
            parsedParams.keyword(searchTerm, searchType, true);
        }
        if (keywordUriCode != null) {
            parsedParams.uri(keywordUriCode);
        }
        if (maxResults != null) {
            parsedParams.maxResults(Integer.parseInt(maxResults));
        }
        if (offset != null) {
            parsedParams.offset(Integer.parseInt(offset));
        }
        if (thesauriDomainName != null) {
            parsedParams.thesauriDomainName(thesauriDomainName);
        }
        if (thesauri == null) {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            ThesaurusManager thesaurusMan = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
            Map listOfThesaurus = thesaurusMan.getThesauriMap();
            for (String t : listOfThesaurus.keySet()) {
                parsedParams.addThesaurus(((Thesaurus)listOfThesaurus.get(t)).getKey());
            }
        } else {
            for (String thesaurusName : thesauri) {
                if (thesaurusName.trim().isEmpty()) continue;
                parsedParams.addThesaurus(thesaurusName.trim());
            }
        }
        boolean addedLang = false;
        for (String targetLang : targetLangs) {
            if (targetLang.trim().isEmpty()) continue;
            parsedParams.addLang(targetLang.trim());
            addedLang = true;
        }
        if (!addedLang) {
            parsedParams.addLang(uiLang);
        }
        return parsedParams;
    }

    private boolean acceptsType(Set<String> acceptContentType, String toCheck) {
        for (String acceptable : acceptContentType) {
            if (!acceptable.contains(toCheck)) continue;
            return true;
        }
        return false;
    }
}

