/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata.schema;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronCriteriaGroupId;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.SchematronCriteriaGroupSpecs;
import org.fao.geonet.services.metadata.schema.AbstractSchematronService;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class SchematronCriteriaGroupService
extends AbstractSchematronService {
    static final String PARAM_SCHEMATRON_ID = "schematronId";
    static final String PARAM_GROUP_NAME = "groupName";
    static final String PARAM_INCLUDE_CRITERIA = "includeCriteria";
    static final String PARAM_INCLUDE_SCHEMATRON = "includeSchematron";
    static final String PARAM_REQUIREMENT = "requirement";
    static final String PARAM_NEW_GROUP_NAME = "newGroupName";
    static final String PARAM_NEW_SCHEMATRON_ID = "newSchematronId";

    @Override
    protected Element delete(Element params, ServiceContext context) throws Exception {
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        int schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        SchematronCriteriaGroupRepository repository = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        try {
            repository.delete((Serializable)new SchematronCriteriaGroupId(groupName, schematronId));
        }
        catch (EmptyResultDataAccessException e) {
            if (!((SchematronRepository)context.getBean(SchematronRepository.class)).exists((Serializable)Integer.valueOf(schematronId))) {
                throw new BadParameterEx(PARAM_SCHEMATRON_ID, (Object)("" + schematronId));
            }
            throw new BadParameterEx(PARAM_GROUP_NAME, (Object)groupName);
        }
        return new Element("ok");
    }

    @Override
    protected Element add(Element params, ServiceContext context) throws Exception {
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        Integer schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        String requirement = Util.getParam((Element)params, (String)PARAM_REQUIREMENT, (String)SchematronRequirement.REQUIRED.name());
        SchematronCriteriaGroup group = new SchematronCriteriaGroup().setId(new SchematronCriteriaGroupId(groupName, schematronId.intValue())).setRequirement(SchematronRequirement.valueOf((String)requirement.toUpperCase()));
        ((SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class)).saveAndFlush((Object)group);
        return new Element("response").addContent((Content)new Element("status").setText("success"));
    }

    @Override
    protected Element list(Element params, ServiceContext context) throws Exception {
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME, null);
        String schematronId = Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID, null);
        boolean includeCriteriaParamPresent = params.getChild(PARAM_INCLUDE_CRITERIA) != null;
        boolean includeCriteria = Util.getParam((Element)params, (String)PARAM_INCLUDE_CRITERIA, (boolean)includeCriteriaParamPresent);
        boolean includeSchematronParamPresent = params.getChild(PARAM_INCLUDE_SCHEMATRON) != null;
        boolean includeSchematron = Util.getParam((Element)params, (String)PARAM_INCLUDE_SCHEMATRON, (boolean)includeSchematronParamPresent);
        SchematronCriteriaGroupRepository repository = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        Specifications spec = null;
        if (schematronId != null) {
            spec = Specifications.where((Specification)SchematronCriteriaGroupSpecs.hasSchematronId((int)Integer.parseInt(schematronId)));
        }
        if (groupName != null) {
            spec = spec == null ? Specifications.where((Specification)SchematronCriteriaGroupSpecs.hasGroupName((String)groupName)) : spec.and(SchematronCriteriaGroupSpecs.hasGroupName((String)groupName));
        }
        Element groups = repository.findAllAsXml((Specification)spec);
        List records = groups.getChildren("record");
        if (!includeCriteria || !includeSchematron) {
            for (Element child : records) {
                if (!includeCriteria) {
                    List criteria = child.getChild("criteria").getChildren();
                    for (Element element : criteria) {
                        element.setContent((Content)element.getChild("id"));
                    }
                }
                if (includeSchematron) continue;
                child.removeChild("schematron");
            }
        }
        return groups;
    }

    @Override
    protected boolean exists(Element params, ServiceContext context) throws Exception {
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        int schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        return ((SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class)).exists((Serializable)new SchematronCriteriaGroupId(groupName, schematronId));
    }

    @Override
    protected Element edit(Element params, ServiceContext context) throws Exception {
        if (params.getChild(PARAM_NEW_GROUP_NAME) != null || params.getChild(PARAM_NEW_SCHEMATRON_ID) != null) {
            return this.renameGroup(params, context);
        }
        return this.updateRequirement(params, context);
    }

    private Element updateRequirement(Element params, ServiceContext context) {
        SchematronCriteriaGroupRepository repository = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        int schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        final String requirement = Util.getParam((Element)params, (String)PARAM_REQUIREMENT, null);
        if (requirement != null) {
            repository.update((Serializable)new SchematronCriteriaGroupId(groupName, schematronId), (Updater)new Updater<SchematronCriteriaGroup>(){

                public void apply(@Nonnull SchematronCriteriaGroup entity) {
                    entity.setRequirement(SchematronRequirement.valueOf((String)requirement.toUpperCase()));
                }
            });
            SchematronRequirement.valueOf((String)requirement.toUpperCase());
            return new Element("ok");
        }
        return new Element("NoUpdate");
    }

    private Element renameGroup(Element params, ServiceContext context) {
        SchematronCriteriaGroupRepository repository = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        int schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        String newRequirement = Util.getParam((Element)params, (String)PARAM_REQUIREMENT, null);
        SchematronCriteriaGroup group = (SchematronCriteriaGroup)repository.findOne((Serializable)new SchematronCriteriaGroupId(groupName, schematronId));
        SchematronRequirement finalRequirement = group.getRequirement();
        if (newRequirement != null) {
            finalRequirement = SchematronRequirement.valueOf((String)newRequirement.toUpperCase());
        }
        String newGroupName = Util.getParam((Element)params, (String)PARAM_NEW_GROUP_NAME, (String)groupName);
        int newSchematronId = Util.getParam((Element)params, (String)PARAM_NEW_SCHEMATRON_ID, (int)schematronId);
        SchematronCriteriaGroup newGroup = new SchematronCriteriaGroup().setId(new SchematronCriteriaGroupId(newGroupName, newSchematronId)).setRequirement(finalRequirement);
        for (SchematronCriteria schematronCriteria : group.getCriteria()) {
            newGroup.addCriteria(schematronCriteria.copy());
        }
        if (group.getId().equals((Object)newGroup.getId())) {
            throw new BadInputEx("newGroupName and newSchematronId have the same value as the old values", newGroupName + ":" + newSchematronId){};
        }
        repository.delete((Serializable)group.getId());
        repository.saveAndFlush((Object)newGroup);
        return new Element("ok");
    }
}

