/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlRootElement;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.MetadataSharingApi;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.services.metadata.BatchOpsMetadataReindexer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ReadWriteController
@Controller
@Deprecated
public class BatchNewOwner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang}/metadata.batch.newowner"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public NewOwnerResult exec(@PathVariable String lang, @RequestParam(value="userId") String targetUsr, @RequestParam(value="groupId") String targetGrp, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        ServiceManager serviceManager = (ServiceManager)appContext.getBean(ServiceManager.class);
        ServiceContext context = serviceManager.createServiceContext("metadata.batch.newowner", lang, request);
        UserSession session = context.getUserSession();
        context.info("Get selected metadata");
        SelectionManager sm = SelectionManager.getManager((UserSession)session);
        ArrayList<String> selection = new ArrayList<String>();
        Set set = sm.getSelection("metadata");
        synchronized (set) {
            selection.addAll(sm.getSelection("metadata"));
        }
        HashSet<Integer> modified = new HashSet<Integer>();
        NewOwnerResult result = this.setNewOwner(context, targetUsr, targetGrp, selection, modified);
        context.info("Re-indexing metadata");
        BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(dataManager, modified);
        r.process();
        return result;
    }

    private NewOwnerResult setNewOwner(ServiceContext context, String targetUsr, String targetGrp, Collection<String> selection, Set<Integer> modified) throws Exception {
        AccessManager accessManager = (AccessManager)context.getBean(AccessManager.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        HashSet<Integer> notFound = new HashSet<Integer>();
        HashSet<Integer> notOwner = new HashSet<Integer>();
        for (String uuid : selection) {
            Integer sourceGrp;
            String id = dataManager.getMetadataId(uuid);
            context.info("Attempting to set metadata owner on: " + id);
            AbstractMetadata info = null;
            if (id != null) {
                info = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(id);
            }
            if (info == null) {
                if (id != null) {
                    notFound.add(Integer.valueOf(id));
                    continue;
                }
                notFound.add(null);
                continue;
            }
            if (!accessManager.isOwner(context, id)) {
                notOwner.add(Integer.valueOf(id));
                continue;
            }
            Integer sourceUsr = info.getSourceInfo().getOwner();
            Vector<OperationAllowedId> sourcePriv = MetadataSharingApi.retrievePrivileges(context, id, sourceUsr, sourceGrp = info.getSourceInfo().getGroupOwner());
            if (sourcePriv.size() == 0) {
                dataManager.copyDefaultPrivForGroup(context, id, targetGrp, false);
                context.info("No privileges for user " + sourceUsr + " on metadata " + id + ", so setting default privileges");
            } else {
                for (OperationAllowedId priv : sourcePriv) {
                    if (sourceGrp != null) {
                        dataManager.unsetOperation(context, id, "" + sourceGrp, "" + priv.getOperationId());
                    }
                    dataManager.setOperation(context, id, targetGrp, "" + priv.getOperationId());
                }
            }
            dataManager.updateMetadataOwner(Integer.parseInt(id), targetUsr, targetGrp);
            modified.add(Integer.valueOf(id));
        }
        return new NewOwnerResult(modified.size(), notOwner.size(), notFound.size());
    }

    @XmlRootElement(name="response")
    public static class NewOwnerResult {
        private final int done;
        private final int notOwner;
        private final int notFound;

        public NewOwnerResult(int total, int notOwner, int notFound) {
            this.done = total;
            this.notOwner = notOwner;
            this.notFound = notFound;
        }

        public int getDone() {
            return this.done;
        }

        public int getNotOwner() {
            return this.notOwner;
        }

        public int getNotFound() {
            return this.notFound;
        }
    }
}

