/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.sampledata;

import com.google.common.collect.Lists;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Add
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String schemaList = Util.getParam((Element)params, (String)"schema");
        String[] serviceStatus = new String[]{"true"};
        String[] serviceError = new String[]{""};
        Element result = new Element("response");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        String[] schemas = schemaList.split(",");
        int count = 0;
        for (String schemaName : schemas) {
            ArrayList sampleDataFilesList;
            Log.info((String)"geonetwork.datamanager", (Object)("Loading sample data for schema " + schemaName));
            Path schemaDir = schemaMan.getSchemaSampleDataDir(schemaName);
            if (schemaDir == null) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Skipping - No samples found for schema '%s'.", schemaName));
                result.addContent((Content)new Element(schemaName).setText("0"));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)("Searching for mefs in: " + schemaDir));
            }
            DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(schemaDir, "*.mef");
            Object object = null;
            try {
                sampleDataFilesList = Lists.newArrayList(newDirectoryStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (newDirectoryStream != null) {
                    if (object != null) {
                        try {
                            newDirectoryStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        newDirectoryStream.close();
                    }
                }
            }
            int schemaCount = 0;
            for (Path file : sampleDataFilesList) {
                try {
                    if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                        Log.debug((String)"geonetwork.datamanager", (Object)String.format("Loading %s sample file %s ...", schemaName, file));
                    }
                    schemaCount += MEFLib.doImport((Element)params, (ServiceContext)context, (Path)file, null).size();
                }
                catch (Exception e) {
                    serviceStatus[0] = "false";
                    serviceError[0] = e.getMessage() + " whilst loading " + file;
                    Log.error((String)"geonetwork.datamanager", (Object)String.format("Error loading %s sample file %s. Error is %s.", schemaName, file, e.getMessage()), (Throwable)e);
                }
                ((DataManager)context.getBean(DataManager.class)).flush();
            }
            count += schemaCount;
            result.addContent((Content)new Element(schemaName).setText("" + schemaCount));
        }
        result.setAttribute("status", serviceStatus[0]);
        result.setAttribute("error", serviceError[0]);
        result.setAttribute("total", "" + count);
        return result;
    }
}

