/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiapi.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;

public class XsltResponseWriter {
    public static final String TRANSLATIONS = "translations";
    Element xml;
    Path xsl;
    Map<String, Object> xslParams = new HashMap<String, Object>();

    public XsltResponseWriter(String serviceName) {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String url = settingManager.getBaseURL();
        Element gui = new Element("gui");
        gui.addContent((Content)new Element("url").setText(url.substring(0, url.length() - 1)));
        gui.addContent((Content)new Element("nodeUrl").setText(settingManager.getNodeURL()));
        gui.addContent((Content)new Element("baseUrl").setText(settingManager.getBaseURL()));
        gui.addContent((Content)new Element("serverUrl").setText(settingManager.getServerURL()));
        gui.addContent((Content)new Element("language").setText("eng"));
        Element settings = settingManager.getAllAsXML(true);
        settings.setName("systemConfig");
        gui.addContent((Content)settings);
        gui.addContent((Content)new Element("reqService").setText(serviceName));
        Element translations = new Element(TRANSLATIONS);
        this.xml = new Element("root").addContent((Content)gui).addContent((Content)translations);
    }

    public XsltResponseWriter withXml(Element xml) {
        this.xml.addContent((Content)xml);
        return this;
    }

    public XsltResponseWriter withXsl(String xsl) {
        Path xslt;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        this.xsl = xslt = dataDirectory.getWebappDir().resolve(xsl);
        return this;
    }

    public XsltResponseWriter withParam(String k, Object v) {
        this.xslParams.put(k, v);
        return this;
    }

    public XsltResponseWriter withParams(Map<String, Object> params) {
        this.xslParams.putAll(params);
        return this;
    }

    public Element asElement() throws Exception {
        return Xml.transform((Element)this.xml, (Path)this.xsl, this.xslParams);
    }

    public String asHtml() throws Exception {
        return Xml.getString((Element)this.asElement());
    }

    public XsltResponseWriter withJson(String json) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        Path jsonPath = dataDirectory.getWebappDir().resolve(json);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map values = (Map)mapper.readValue(jsonPath.toFile(), Map.class);
            Element element = this.xml.getChild(TRANSLATIONS);
            values.forEach((k, v) -> element.addContent((Content)new Element(k).setText(v)));
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork.search", (Object)String.format("Can't find JSON file '%s'.", jsonPath.toString()));
        }
        return this;
    }
}

