/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.standards;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.standards.StandardsUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.editorconfig.BatchEditing;
import org.fao.geonet.kernel.schema.editorconfig.Editor;
import org.fao.geonet.kernel.schema.labels.Codelists;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/standards", "/{portal}/api/0.1/standards"})
@Api(value="standards", tags={"standards"}, description="Standard related operations")
@Controller(value="standards")
public class StandardsApi
implements ApplicationContextAware {
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @ApiOperation(value="Get standards", nickname="getStandards")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of standards.")})
    public List<MetadataSchema> getConfigurations() throws Exception {
        Set schemaIds = this.schemaManager.getSchemas();
        ArrayList<MetadataSchema> schemaList = new ArrayList<MetadataSchema>(schemaIds.size());
        schemaIds.stream().forEach(id -> schemaList.add(this.schemaManager.getSchema(id)));
        return schemaList;
    }

    @ApiOperation(value="Reload standards", nickname="reloadStandards")
    @RequestMapping(value={"/reload"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Standards reloaded.")})
    public void reloadSchema() throws Exception {
        Set schemaIds = this.schemaManager.getSchemas();
        schemaIds.stream().forEach(id -> this.schemaManager.reloadSchema(id));
    }

    @ApiOperation(value="Get batch editor configuration for standards", nickname="getBatchConfigurations")
    @RequestMapping(value={"/batchconfiguration"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Batch editor configuration.")})
    @ResponseBody
    public Map<String, BatchEditing> getConfigurations(@ApiParam(value="Schema identifiers", required=false, example="iso19139") @RequestParam(required=false) String[] schema) throws Exception {
        List<Object> listOfRequestedSchema = schema == null ? new ArrayList() : Arrays.asList(schema);
        Set listOfSchemas = this.schemaManager.getSchemas();
        HashMap<String, BatchEditing> schemasConfig = new HashMap<String, BatchEditing>();
        for (String schemaIdentifier : listOfSchemas) {
            MetadataSchema metadataSchema;
            Editor editorConfiguration;
            if (listOfRequestedSchema.size() != 0 && !listOfRequestedSchema.contains(schemaIdentifier) || (editorConfiguration = (metadataSchema = this.schemaManager.getSchema(schemaIdentifier)).getConfigEditor()) == null) continue;
            schemasConfig.put(schemaIdentifier, editorConfiguration.getBatchEditing());
        }
        return schemasConfig;
    }

    @ApiOperation(value="Get batch editor configuration for a standard", nickname="getBatchConfiguration")
    @RequestMapping(value={"/{schema}/batchconfiguration"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, BatchEditing> getConfiguration(@ApiParam(value="Schema identifier", required=true, example="iso19139") @PathVariable String schema) throws Exception {
        HashMap<String, BatchEditing> schemasConfig = new HashMap<String, BatchEditing>();
        MetadataSchema metadataSchema = this.schemaManager.getSchema(schema);
        Editor editorConfiguration = metadataSchema.getConfigEditor();
        if (editorConfiguration != null) {
            schemasConfig.put(schema, editorConfiguration.getBatchEditing());
        }
        return schemasConfig;
    }

    @ApiOperation(value="Get codelist translations", nickname="getSchemaTranslations")
    @RequestMapping(value={"/{schema}/codelists/{codelist}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getSchemaTranslations(@ApiParam(value="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @ApiParam(value="Codelist element name or alias") @PathVariable String codelist, @RequestParam(required=false) String parent, @RequestParam(required=false) String displayIf, @RequestParam(required=false) String xpath, @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getCodelist(codelist, this.schemaManager, schema, parent, xpath, isoType, context, displayIf);
        List listOfEntry = e.getChildren("entry");
        for (Element entry : listOfEntry) {
            response.put(entry.getChildText("code"), entry.getChildText("label"));
        }
        return response;
    }

    @ApiOperation(value="Get codelist details", nickname="getSchemaCodelistsWithDetails")
    @RequestMapping(value={"/{schema}/codelists/{codelist}/details"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public Codelists.Codelist getSchemaCodelistsWithDetails(@ApiParam(value="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @ApiParam(value="Codelist element name or alias") @PathVariable String codelist, @ApiParam(value="Parent name with namespace which may indicate a more precise label as defined in context attribute.") @RequestParam(required=false) String parent, @ApiParam(value="Display if condition as defined in the codelist.xml file. Allows to select a more precise codelist when more than one is defined for same name.") @RequestParam(required=false) String displayIf, @ApiParam(value="XPath of the element to target which may indicate a more precise label as defined in context attribute.") @RequestParam(required=false) String xpath, @ApiParam(value="ISO type of the element to target which may indicate a more precise label as defined in context attribute. (Same as context. TODO: Deprecate ?)") @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getCodelist(codelist, this.schemaManager, schema, parent, xpath, isoType, context, displayIf);
        return (Codelists.Codelist)Xml.unmarshall((Element)e, Codelists.Codelist.class);
    }

    @ApiOperation(value="Get descriptor details", nickname="getElementDetails")
    @RequestMapping(value={"/{schema}/descriptors/{element}/details"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public org.fao.geonet.kernel.schema.labels.Element getElementDetails(@ApiParam(value="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @ApiParam(value="Descriptor name", required=true) @PathVariable String element, @RequestParam(required=false) String parent, @RequestParam(required=false) String displayIf, @RequestParam(required=false) String xpath, @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getLabel(element, this.schemaManager, schema, parent, xpath, isoType, displayIf, context);
        return (org.fao.geonet.kernel.schema.labels.Element)Xml.unmarshall((Element)e, org.fao.geonet.kernel.schema.labels.Element.class);
    }

    @ApiOperation(value="Get editor associated resources panel configuration", nickname="getEditorAssociatedPanelConfiguration")
    @RequestMapping(value={"/{schema}/editor/associatedpanel/config/{name:[a-zA-Z]+}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getEditorAssociatedPanelConfiguration(@ApiParam(value="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @ApiParam(value="Configuration identifier", required=true, defaultValue="default", example="default") @PathVariable String name) throws Exception {
        HashSet<String> schemasProcessed = new HashSet<String>();
        while (StringUtils.isNotEmpty((String)schema) && !schemasProcessed.contains(schema)) {
            schemasProcessed.add(schema);
            MetadataSchema metadataSchema = this.schemaManager.getSchema(schema);
            Path schemaDir = metadataSchema.getSchemaDir();
            Path configFile = schemaDir.resolve("config").resolve("associated-panel").resolve(name + ".json");
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    String jsonConfig = new String(Files.readAllBytes(configFile));
                    new JSONObject(jsonConfig);
                    return jsonConfig;
                }
                catch (Exception e) {
                    throw new WebApplicationException(String.format("Associated panel configuration '%s' for schema '%s' is invalid. Error is: %s", name, metadataSchema.getName(), e.getMessage()));
                }
            }
            schema = metadataSchema.getDependsOn();
        }
        throw new ResourceNotFoundException(String.format("Associated panel '%s' configuration not found for schema and its dependency '%s'.", name, ((Object)schemasProcessed).toString()));
    }
}

