/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.processing.report.ErrorReport;
import org.fao.geonet.api.processing.report.InfoReport;
import org.fao.geonet.api.processing.report.ProcessingReport;
import org.fao.geonet.api.processing.report.Report;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;

@XmlType(propOrder={"uuid", "startIsoDateTime", "endIsoDateTime", "ellapsedTimeInSeconds", "totalTimeInSeconds", "infos", "errors"})
public abstract class MetadataProcessingReport
extends ProcessingReport {
    protected int totalRecords = 0;
    @XmlAttribute
    protected int processedRecords = 0;
    @XmlAttribute
    protected int nullRecords = 0;
    protected Set<Integer> metadata = new HashSet<Integer>();
    protected Set<Integer> notFound = new HashSet<Integer>();
    protected Set<Integer> notEditable = new HashSet<Integer>();
    protected Map<Integer, List<Report>> metadataErrors = new HashMap<Integer, List<Report>>();
    protected Map<Integer, List<InfoReport>> metadataInfos = new HashMap<Integer, List<InfoReport>>();

    @XmlElement(name="errors")
    public Map<Integer, List<Report>> getMetadataErrors() {
        return this.metadataErrors;
    }

    public synchronized void addMetadataError(int metadataId, String metadataUUID, boolean draft, boolean approved, Exception error) {
        ErrorReport errorReport = new ErrorReport(error);
        errorReport.setUuid(metadataUUID);
        errorReport.setDraft(draft);
        errorReport.setApproved(approved);
        if (this.metadataErrors.get(metadataId) == null) {
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
            errors.add(errorReport);
            this.metadataErrors.put(metadataId, errors);
        } else {
            this.metadataErrors.get(metadataId).add(errorReport);
        }
    }

    public void addMetadataError(AbstractMetadata metadata, Exception error) {
        this.addMetadataError(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()), error);
    }

    public synchronized void addMetadataError(int metadataId, String metadataUUID, boolean draft, boolean approved, String error) {
        ErrorReport errorReport = new ErrorReport(error);
        errorReport.setUuid(metadataUUID);
        errorReport.setDraft(draft);
        errorReport.setApproved(approved);
        if (this.metadataErrors.get(metadataId) == null) {
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
            errors.add(errorReport);
            this.metadataErrors.put(metadataId, errors);
        } else {
            this.metadataErrors.get(metadataId).add(errorReport);
        }
    }

    public void addMetadataError(AbstractMetadata metadata, String error) {
        this.addMetadataError(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()), error);
    }

    @XmlElement(name="infos")
    public Map<Integer, List<InfoReport>> getMetadataInfos() {
        return this.metadataInfos;
    }

    public void addMetadataInfos(int metadataId, String metadataUUID, boolean draft, boolean approved, String message) {
        InfoReport infoReport = new InfoReport(message);
        infoReport.setUuid(metadataUUID);
        infoReport.setDraft(draft);
        infoReport.setApproved(approved);
        if (this.metadataInfos.get(metadataId) == null) {
            ArrayList<InfoReport> infos = new ArrayList<InfoReport>();
            infos.add(infoReport);
            this.metadataInfos.put(metadataId, infos);
        } else {
            this.metadataInfos.get(metadataId).add(infoReport);
        }
    }

    public void addMetadataInfos(AbstractMetadata metadata, String message) {
        this.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()), message);
    }

    private boolean isMetadataDraft(int metadataId) {
        boolean metadataDraft = false;
        try {
            metadataDraft = ((IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class)).isMetadataDraft(metadataId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error detecting if metadata is draft");
        }
        return metadataDraft;
    }

    private boolean isMetadataApproved(int metadataId) {
        boolean metadataApproved = false;
        try {
            metadataApproved = ((IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class)).isMetadataApproved(metadataId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error detecting if metadata is approved");
        }
        return metadataApproved;
    }

    @XmlTransient
    protected synchronized boolean isProcessing() {
        return this.totalRecords != this.processedRecords;
    }

    public synchronized int getNumberOfNullRecords() {
        return this.nullRecords;
    }

    public synchronized void incrementNullRecords() {
        ++this.nullRecords;
    }

    @XmlAttribute
    public synchronized int getNumberOfRecords() {
        return this.totalRecords;
    }

    public synchronized void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public synchronized int getNumberOfRecordsProcessed() {
        return this.processedRecords;
    }

    public synchronized void incrementProcessedRecords() {
        ++this.processedRecords;
    }

    public synchronized void addMetadataId(int metadataId) {
        this.metadata.add(metadataId);
    }

    public synchronized Set<Integer> getMetadata() {
        return this.metadata;
    }

    public synchronized void addNotFoundMetadataId(int metadataId) {
        this.notFound.add(metadataId);
    }

    public synchronized int getNumberOfRecordNotFound() {
        return this.notFound.size();
    }

    public synchronized void addNotEditableMetadataId(int metadataId) {
        this.notEditable.add(metadataId);
    }

    public synchronized int getNumberOfRecordsNotEditable() {
        return this.notEditable.size();
    }

    public synchronized int getNumberOfRecordsWithErrors() {
        return this.metadataErrors.size();
    }
}

