/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.function;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.function.DocumentBoosting;
import org.jdom.Element;

public class ImportantDocument
implements DocumentBoosting {
    private static final String NOTNULL = "NOTNULL";
    private HashMap<String, HashMap<String, Float>> config = new HashMap();

    public ImportantDocument(String fields, String values, String boosts) {
        List<String> fieldList = Arrays.asList(fields.split(","));
        List<String> valueList = Arrays.asList(values.split(","));
        List<String> boostList = Arrays.asList(boosts.split(","));
        int idx = 0;
        for (String f : fieldList) {
            Float b = Float.valueOf(Float.parseFloat(boostList.get(idx)));
            HashMap<String, Float> hm = this.config.get(f);
            if (hm == null) {
                hm = new HashMap();
            }
            hm.put(valueList.get(idx), b);
            this.config.put(f, hm);
            ++idx;
        }
    }

    @Override
    public Float getBoost(Element doc) {
        Float documentBoost = null;
        for (Object o : doc.getChildren()) {
            Element field = (Element)o;
            String name = field.getAttributeValue(SearchManager.LuceneFieldAttribute.NAME.toString());
            HashMap<String, Float> fieldBoosts = this.config.get(name);
            if (fieldBoosts == null) continue;
            String value = field.getAttributeValue(SearchManager.LuceneFieldAttribute.STRING.toString());
            Float b = fieldBoosts.get(value);
            if (b != null) {
                documentBoost = this.addBoost(documentBoost, b);
                continue;
            }
            if (!fieldBoosts.containsKey(NOTNULL)) continue;
            documentBoost = this.addBoost(documentBoost, fieldBoosts.get(NOTNULL));
        }
        return documentBoost;
    }

    private Float addBoost(Float documentBoost, Float b) {
        if (documentBoost == null) {
            documentBoost = Float.valueOf(1.0f);
        }
        documentBoost = Float.valueOf(documentBoost.floatValue() + b.floatValue());
        return documentBoost;
    }
}

