/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.LuceneQueryInput;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.LuceneUtils;
import org.fao.geonet.kernel.search.UserQueryInput;
import org.fao.geonet.kernel.search.WildCardStringAnalyzer;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;

public class LuceneQueryBuilder {
    private static final String OR_SEPARATOR = " or ";
    private static final String FIELD_OR_SEPARATOR = "_OR_";
    private static final String FACET_QUERY_AND_SEPARATOR = "&";
    private static final String STRING_TOKENIZER_DELIMITER = " \n\r\t";
    private static final Double minBoundingLatitudeValue = -90.0;
    private static final Double maxBoundingLatitudeValue = 90.0;
    private static final Double minBoundingLongitudeValue = -180.0;
    private static final Double maxBoundingLongitudeValue = 180.0;
    private final LuceneConfig luceneConfig;
    private Set<String> _tokenizedFieldSet;
    private PerFieldAnalyzerWrapper _analyzer;
    private Map<String, LuceneConfig.LuceneConfigNumericField> _numericFieldSet;
    private FacetsConfig _taxonomyConfiguration;
    private String _language;
    private boolean spatialCriteriaAdded;
    private boolean temporalCriteriaAdded;
    private boolean templateCriteriaAdded;
    private boolean draftCriteriaAdded;

    public LuceneQueryBuilder(LuceneConfig luceneConfig, Set<String> _tokenizedFieldSet, PerFieldAnalyzerWrapper analyzer, String langCode) {
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        this._tokenizedFieldSet = _tokenizedFieldSet;
        this._numericFieldSet = luceneConfig.getNumericFields();
        this._taxonomyConfiguration = luceneConfig.getTaxonomyConfiguration();
        this.luceneConfig = luceneConfig;
        this._analyzer = analyzer;
        this._language = langCode;
    }

    static Query constructQueryFromAnalyzedString(LuceneConfig luceneConfig, String string, String luceneIndexField, String similarity, Query query, String analyzedString, Set<String> tokenizedFieldSet) {
        if (StringUtils.isNotBlank((String)analyzedString)) {
            if (string.indexOf(42) < 0 && string.indexOf(63) < 0) {
                if (tokenizedFieldSet.contains(luceneIndexField) && analyzedString.contains(" ")) {
                    String[] terms = analyzedString.split(" ");
                    BooleanQuery booleanQuery = new BooleanQuery();
                    query = booleanQuery;
                    for (String term : terms) {
                        booleanQuery.add(LuceneQueryBuilder.createFuzzyOrTermQuery(luceneConfig, luceneIndexField, similarity, term), BooleanClause.Occur.MUST);
                    }
                } else {
                    query = LuceneQueryBuilder.createFuzzyOrTermQuery(luceneConfig, luceneIndexField, similarity, analyzedString);
                }
            } else {
                query = new WildcardQuery(new Term(luceneIndexField, analyzedString));
            }
        }
        return query;
    }

    private static Query createFuzzyOrTermQuery(LuceneConfig luceneConfig, String luceneIndexField, String similarity, String analyzedString) {
        TermQuery query = null;
        if (similarity != null && luceneConfig.applySimilarity(luceneIndexField)) {
            Float minimumSimilarity = Float.valueOf(Float.parseFloat(similarity));
            if (minimumSimilarity.floatValue() < 1.0f) {
                int maxEdits = Math.min((int)((1.0 - (double)minimumSimilarity.floatValue()) * 10.0), 2);
                query = new FuzzyQuery(new Term(luceneIndexField, analyzedString), maxEdits);
            } else if (minimumSimilarity.floatValue() > 1.0f) {
                throw new IllegalArgumentException("similarity cannot be > 1.  The provided value was " + similarity);
            }
        }
        if (query == null) {
            query = new TermQuery(new Term(luceneIndexField, analyzedString));
        }
        return query;
    }

    public static NumericRangeQuery<? extends Number> buildNumericRangeQueryForType(String fieldName, String min, String max, boolean minInclusive, boolean maxInclusive, String type) {
        NumericRangeQuery rangeQuery = "double".equals(type) ? NumericRangeQuery.newDoubleRange((String)fieldName, (Double)(min == null ? Double.MIN_VALUE : Double.parseDouble(min)), (Double)(max == null ? Double.MAX_VALUE : Double.parseDouble(max)), (boolean)true, (boolean)true) : ("float".equals(type) ? NumericRangeQuery.newFloatRange((String)fieldName, (Float)Float.valueOf(min == null ? Float.MIN_VALUE : Float.parseFloat(min)), (Float)Float.valueOf(max == null ? Float.MAX_VALUE : Float.parseFloat(max)), (boolean)true, (boolean)true) : ("long".equals(type) ? NumericRangeQuery.newLongRange((String)fieldName, (Long)(min == null ? Long.MIN_VALUE : Long.parseLong(min)), (Long)(max == null ? Long.MAX_VALUE : Long.parseLong(max)), (boolean)true, (boolean)true) : NumericRangeQuery.newIntRange((String)fieldName, (Integer)(min == null ? Integer.MIN_VALUE : Integer.parseInt(min)), (Integer)(max == null ? Integer.MAX_VALUE : Integer.parseInt(max)), (boolean)true, (boolean)true)));
        return rangeQuery;
    }

    static Query addLocaleTerm(Query query, String langCode, SettingInfo.SearchRequestLanguage requestedLanguageOnly) {
        BooleanQuery booleanQuery;
        if (langCode == null || requestedLanguageOnly == null) {
            return query;
        }
        if (query instanceof BooleanQuery) {
            booleanQuery = (BooleanQuery)query;
        } else {
            booleanQuery = new BooleanQuery();
            booleanQuery.add(query, BooleanClause.Occur.MUST);
        }
        requestedLanguageOnly.addQuery(booleanQuery, langCode);
        return booleanQuery;
    }

    public Query build(LuceneQueryInput luceneQueryInput) {
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("LuceneQueryBuilder: luceneQueryInput is: \n" + luceneQueryInput.toString()));
        }
        Query result = this.buildBaseQuery(luceneQueryInput);
        if (luceneQueryInput.getFacetQueries().size() > 0) {
            result = this.addFacetQueries(result, luceneQueryInput.getFacetQueries());
        }
        return result;
    }

    private Query buildBaseQuery(LuceneQueryInput luceneQueryInput) {
        LinkedHashSet<String> processedRangeFields = new LinkedHashSet<String>();
        BooleanQuery query = new BooleanQuery();
        this.addPrivilegeQuery(luceneQueryInput, query);
        String similarity = luceneQueryInput.getSimilarity();
        Map<String, Set<String>> searchCriteria = luceneQueryInput.getSearchCriteria();
        LinkedHashMap<String, Set<String>> searchCriteriaOR = new LinkedHashMap<String, Set<String>>();
        this.spatialCriteriaAdded = false;
        this.temporalCriteriaAdded = false;
        this.templateCriteriaAdded = false;
        this.draftCriteriaAdded = false;
        Iterator<Map.Entry<String, Set<String>>> i = searchCriteria.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Set<String>> entry = i.next();
            String fieldName = entry.getKey();
            Set<String> fieldValues = entry.getValue();
            if (!fieldName.contains(FIELD_OR_SEPARATOR)) continue;
            i.remove();
            if (fieldName.contains("northBL") || fieldName.contains("southBL") || fieldName.contains("eastBL") || fieldName.contains("westBL") || fieldName.contains("relation") || fieldName.contains("without") || fieldName.contains("phrase") || fieldName.contains("extTo") || fieldName.contains("extFrom") || fieldName.contains("featured") || fieldName.contains("template") || UserQueryInput.RANGE_QUERY_FIELDS.contains(fieldName)) continue;
            Scanner scanner = new Scanner(fieldName).useDelimiter(FIELD_OR_SEPARATOR);
            while (scanner.hasNext()) {
                Set<String> values;
                String field = scanner.next();
                if (field.equals("or")) {
                    field = "any";
                    values = (Set)searchCriteriaOR.get(field);
                    if (values == null) {
                        values = new LinkedHashSet();
                    }
                    values.addAll(fieldValues);
                    searchCriteriaOR.put(field, values);
                    continue;
                }
                values = (LinkedHashSet<String>)searchCriteriaOR.get(field);
                if (values == null) {
                    values = new LinkedHashSet<String>();
                }
                values.addAll(fieldValues);
                searchCriteriaOR.put(field, values);
            }
        }
        query = this.buildORQuery(searchCriteriaOR, query, similarity);
        query = this.buildANDQuery(searchCriteria, query, similarity, processedRangeFields);
        if (!this.templateCriteriaAdded) {
            BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            TermQuery q = new TermQuery(new Term("_isTemplate", "n"));
            query.add((Query)q, occur);
            this.templateCriteriaAdded = true;
        }
        this.draftCriteria(null, query);
        if (StringUtils.isNotEmpty((String)this._language)) {
            if (Log.isDebugEnabled((String)"geonetwork.lucene")) {
                Log.debug((String)"geonetwork.lucene", (Object)("adding locale query for language " + this._language));
            }
            return LuceneQueryBuilder.addLocaleTerm((Query)query, this._language, luceneQueryInput.isRequestedLanguageOnly());
        }
        if (Log.isDebugEnabled((String)"geonetwork.lucene")) {
            Log.debug((String)"geonetwork.lucene", (Object)"no language set, not adding locale query");
        }
        return query;
    }

    private Query addFacetQueries(Query baseQuery, Set<String> facetQueries) {
        DrillDownQuery result = new DrillDownQuery(this._taxonomyConfiguration, baseQuery);
        for (String facetQuery : facetQueries) {
            this.addFacetQuery(facetQuery, result);
        }
        return result;
    }

    private void addFacetQuery(String facetQuery, DrillDownQuery result) {
        for (String drillDownParam : facetQuery.split(FACET_QUERY_AND_SEPARATOR)) {
            DrillDownPath drillDownPath = new DrillDownPath(drillDownParam);
            result.add(drillDownPath.getDimension(), drillDownPath.getPath());
        }
    }

    private BooleanQuery buildORQuery(Map<String, Set<String>> searchCriteria, BooleanQuery query, String similarity) {
        if (searchCriteria.size() == 0) {
            return query;
        }
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (String requestedField : searchCriteria.keySet()) {
            if (UserQueryInput.SECURITY_FIELDS.contains(requestedField) || "editable".equals(requestedField)) continue;
            fields.add(requestedField);
        }
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        BooleanClause.Occur tokenOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (String fieldName : fields) {
            Set<String> fieldValues = searchCriteria.get(fieldName);
            for (String fieldValue : fieldValues) {
                if (fieldValue.contains(OR_SEPARATOR)) {
                    this.addSeparatedTextField(fieldValue, OR_SEPARATOR, fieldName, booleanQuery);
                    continue;
                }
                if ("any".equals(fieldName) || "all".equals(fieldName)) {
                    BooleanClause anyClause = null;
                    if (!this.onlyWildcard(fieldValue)) {
                        anyClause = this.tokenizeSearchParam(fieldValue, similarity, tokenOccur, occur);
                    }
                    if (anyClause == null || !StringUtils.isNotEmpty((String)anyClause.toString())) continue;
                    booleanQuery.add(anyClause);
                    continue;
                }
                if (!this._tokenizedFieldSet.contains(fieldName)) {
                    TermQuery termQuery = new TermQuery(new Term(fieldName, fieldValue.trim()));
                    BooleanClause clause = new BooleanClause((Query)termQuery, tokenOccur);
                    booleanQuery.add(clause);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(fieldValue.trim(), STRING_TOKENIZER_DELIMITER);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    Query subQuery = this.textFieldToken(token, fieldName, similarity);
                    if (subQuery == null) continue;
                    BooleanClause subClause = new BooleanClause(subQuery, tokenOccur);
                    booleanQuery.add(subClause);
                }
            }
        }
        BooleanClause booleanClause = new BooleanClause((Query)booleanQuery, occur);
        query.add(booleanClause);
        return query;
    }

    private BooleanClause tokenizeSearchParam(String fieldValue, String similarity, BooleanClause.Occur singleTokenOccur, BooleanClause.Occur moreTokensOccur) {
        BooleanClause anyClause = null;
        StringTokenizer st = new StringTokenizer(fieldValue, STRING_TOKENIZER_DELIMITER);
        if (st.countTokens() == 1) {
            String token = st.nextToken();
            Query subQuery = this.textFieldToken(token, "any", similarity);
            if (subQuery != null) {
                anyClause = new BooleanClause(subQuery, singleTokenOccur);
            }
        } else {
            BooleanQuery orBooleanQuery = new BooleanQuery();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Query subQuery = this.textFieldToken(token, "any", similarity);
                if (subQuery == null) continue;
                BooleanClause subClause = new BooleanClause(subQuery, moreTokensOccur);
                orBooleanQuery.add(subClause);
            }
            anyClause = new BooleanClause((Query)orBooleanQuery, singleTokenOccur);
        }
        return anyClause;
    }

    private BooleanQuery buildANDQuery(Map<String, Set<String>> searchCriteria, BooleanQuery query, String similarity, Set<String> processedRangeFields) {
        for (Map.Entry<String, Set<String>> searchCriterium : searchCriteria.entrySet()) {
            String fieldName = searchCriterium.getKey();
            Set<String> fieldValues = searchCriterium.getValue();
            this.addANDCriteria(fieldName, fieldValues, similarity, query, searchCriteria, processedRangeFields);
        }
        return query;
    }

    private void addANDCriteria(String fieldName, Set<String> fieldValues, String similarity, BooleanQuery query, Map<String, Set<String>> searchCriteria, Set<String> processedRangeFields) {
        BooleanQuery bq = new BooleanQuery();
        BooleanClause.Occur qOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        if (UserQueryInput.SECURITY_FIELDS.contains(fieldName) || "editable".equals(fieldName)) {
            return;
        }
        boolean criteriaIsASet = fieldValues.size() > 1;
        for (String fieldValue : fieldValues) {
            if ("any".equals(fieldName)) {
                this.addAnyTextQuery(fieldValue, similarity, criteriaIsASet ? bq : query);
                continue;
            }
            if ("_uuid".equals(fieldName) || "uuid".equals(fieldName)) {
                this.addUUIDQuery(fieldValue, similarity, criteriaIsASet, bq, query);
                continue;
            }
            if ("northBL".equals(fieldName) || "southBL".equals(fieldName) || "eastBL".equals(fieldName) || "westBL".equals(fieldName) || "relation".equals(fieldName)) {
                this.addBBoxQuery(searchCriteria, query);
                continue;
            }
            if ("_isTemplate".equals(fieldName) || "template".equals(fieldName)) {
                this.templateCriteria(fieldValue, query);
                continue;
            }
            if ("_draft".equals(fieldName)) {
                this.draftCriteria(fieldValue, query);
                continue;
            }
            if ("all".equals(fieldName)) {
                this.addRequiredTextField(fieldValue, "any", similarity, criteriaIsASet ? bq : query);
                continue;
            }
            if ("or".equals(fieldName)) {
                this.addNotRequiredTextField(fieldValue, "any", similarity, criteriaIsASet ? bq : query);
                continue;
            }
            if (fieldName.startsWith("without")) {
                this.addProhibitedTextField(fieldValue, fieldName.contains("-") ? fieldName.split("-")[1] : "any", criteriaIsASet ? bq : query);
                continue;
            }
            if ("phrase".equals(fieldName)) {
                this.phraseCriteria(fieldValue, query, qOccur);
                continue;
            }
            if ("extFrom".equals(fieldName) || "extTo".equals(fieldName)) {
                if (this.temporalCriteriaAdded) continue;
                this.temporalCriteriaAdded = this.temporalCriteria(searchCriteria, query);
                continue;
            }
            if (UserQueryInput.RANGE_QUERY_FIELDS.contains(fieldName)) {
                this.rangeCriteria(searchCriteria, fieldName, query, processedRangeFields);
                continue;
            }
            if ("featured".equals(fieldName)) {
                this.featuredCriteria(fieldValue, bq);
                continue;
            }
            if (criteriaIsASet) {
                this.addNotRequiredTextField(fieldValue, fieldName, similarity, bq);
                continue;
            }
            if (fieldValue.contains(OR_SEPARATOR)) {
                this.addSeparatedTextField(fieldValue, OR_SEPARATOR, fieldName, bq);
                continue;
            }
            this.addRequiredTextField(fieldValue, fieldName, similarity, query);
        }
        if (bq.clauses().size() > 0) {
            query.add((Query)bq, qOccur);
        }
    }

    private void featuredCriteria(String fieldValue, BooleanQuery bq) {
        if ("true".equals(fieldValue)) {
            BooleanClause.Occur featuredOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            TermQuery featuredQuery = new TermQuery(new Term("_op6", "1"));
            BooleanClause featuredClause = new BooleanClause((Query)featuredQuery, featuredOccur);
            bq.add(featuredClause);
            TermQuery viewQuery = new TermQuery(new Term("_op0", "1"));
            BooleanClause viewClause = new BooleanClause((Query)viewQuery, featuredOccur);
            bq.add(viewClause);
        }
    }

    private void rangeCriteria(Map<String, Set<String>> searchCriteria, String fieldName, BooleanQuery query, Set<String> processedRangeFields) {
        String rangeQueryField = UserQueryInput.getRangeField(fieldName);
        if (!processedRangeFields.contains(rangeQueryField)) {
            Set<String> to;
            Set<String> from;
            if (rangeQueryField.equals(fieldName)) {
                to = from = searchCriteria.get(rangeQueryField);
            } else {
                from = searchCriteria.get(UserQueryInput.getFrom(rangeQueryField));
                to = searchCriteria.get(UserQueryInput.getTo(rangeQueryField));
            }
            this.addRangeQuery(query, from != null ? (String)from.toArray()[0] : null, to != null ? (String)to.toArray()[0] : null, rangeQueryField);
            processedRangeFields.add(rangeQueryField);
        }
    }

    private void phraseCriteria(String fieldValue, BooleanQuery query, BooleanClause.Occur qOccur) {
        PhraseQuery phraseQ = null;
        if (StringUtils.isNotBlank((String)fieldValue)) {
            phraseQ = new PhraseQuery();
            qOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            StringTokenizer st = new StringTokenizer(fieldValue, STRING_TOKENIZER_DELIMITER);
            while (st.hasMoreTokens()) {
                String phraseElement = st.nextToken();
                phraseElement = phraseElement.trim().toLowerCase();
                phraseQ.add(new Term("any", phraseElement));
            }
        }
        if (phraseQ != null) {
            query.add((Query)phraseQ, qOccur);
        }
    }

    private void draftCriteria(String fieldValue, BooleanQuery query) {
        if (!this.draftCriteriaAdded) {
            BooleanQuery templateQ;
            BooleanClause.Occur templateOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            if (fieldValue != null) {
                if (fieldValue.contains(OR_SEPARATOR)) {
                    templateQ = new BooleanQuery();
                    this.addSeparatedTextField(fieldValue, OR_SEPARATOR, "_draft", templateQ);
                } else {
                    templateQ = new TermQuery(new Term("_draft", fieldValue));
                }
            } else {
                templateQ = new BooleanQuery();
                this.addSeparatedTextField("n or e", OR_SEPARATOR, "_draft", templateQ);
            }
            query.add((Query)templateQ, templateOccur);
            this.draftCriteriaAdded = true;
        }
    }

    private void templateCriteria(String fieldValue, BooleanQuery query) {
        if (!this.templateCriteriaAdded) {
            BooleanQuery templateQ;
            BooleanClause.Occur templateOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            if (fieldValue != null) {
                if (fieldValue.contains(OR_SEPARATOR)) {
                    templateQ = new BooleanQuery();
                    this.addSeparatedTextField(fieldValue, OR_SEPARATOR, "_isTemplate", templateQ);
                } else {
                    templateQ = fieldValue.equals("y") || fieldValue.equals("s") || fieldValue.equals("t") ? new TermQuery(new Term("_isTemplate", fieldValue)) : new TermQuery(new Term("_isTemplate", "n"));
                }
            } else {
                templateQ = new TermQuery(new Term("_isTemplate", "n"));
            }
            query.add((Query)templateQ, templateOccur);
            this.templateCriteriaAdded = true;
        }
    }

    private boolean temporalCriteria(Map<String, Set<String>> searchCriteria, BooleanQuery query) {
        String extFrom;
        Set<String> from = searchCriteria.get("extFrom");
        Set<String> to = searchCriteria.get("extTo");
        String extTo = to != null ? (String)to.toArray()[0] : null;
        String string = extFrom = from != null ? (String)from.toArray()[0] : null;
        if (StringUtils.isNotBlank((String)extTo) || StringUtils.isNotBlank((String)extFrom)) {
            BooleanQuery temporalExtentQuery = new BooleanQuery();
            BooleanClause.Occur temporalExtentOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            BooleanClause.Occur temporalRangeQueryOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
            TermRangeQuery temporalRangeQuery = TermRangeQuery.newStringRange((String)"tempExtentBegin", (String)extFrom, (String)extTo, (boolean)true, (boolean)true);
            BooleanClause temporalRangeQueryClause = new BooleanClause((Query)temporalRangeQuery, temporalRangeQueryOccur);
            temporalExtentQuery.add(temporalRangeQueryClause);
            temporalRangeQuery = TermRangeQuery.newStringRange((String)"tempExtentEnd", (String)extFrom, (String)extTo, (boolean)true, (boolean)true);
            temporalRangeQueryClause = new BooleanClause((Query)temporalRangeQuery, temporalRangeQueryOccur);
            temporalExtentQuery.add(temporalRangeQueryClause);
            if (StringUtils.isNotBlank((String)extTo) && StringUtils.isNotBlank((String)extFrom)) {
                BooleanQuery tempQuery = new BooleanQuery();
                temporalRangeQuery = TermRangeQuery.newStringRange((String)"tempExtentEnd", (String)extTo, null, (boolean)true, (boolean)true);
                temporalRangeQueryClause = new BooleanClause((Query)temporalRangeQuery, temporalExtentOccur);
                tempQuery.add(temporalRangeQueryClause);
                temporalRangeQuery = TermRangeQuery.newStringRange((String)"tempExtentBegin", null, (String)extFrom, (boolean)true, (boolean)true);
                temporalRangeQueryClause = new BooleanClause((Query)temporalRangeQuery, temporalExtentOccur);
                tempQuery.add(temporalRangeQueryClause);
                temporalExtentQuery.add((Query)tempQuery, temporalRangeQueryOccur);
            }
            if (temporalExtentQuery.clauses().size() > 0) {
                temporalRangeQueryClause = new BooleanClause((Query)temporalExtentQuery, temporalExtentOccur);
                query.add(temporalRangeQueryClause);
            }
        }
        return true;
    }

    private Query textFieldToken(String string, String luceneIndexField, String similarity) {
        String analyzedString;
        if (string == null) {
            throw new IllegalArgumentException("Cannot create Lucene query for null string");
        }
        Query query = null;
        if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
            WildCardStringAnalyzer wildCardStringAnalyzer = new WildCardStringAnalyzer();
            analyzedString = wildCardStringAnalyzer.analyze(string, luceneIndexField, this._analyzer, this._tokenizedFieldSet);
        } else {
            analyzedString = LuceneSearcher.analyzeQueryText(luceneIndexField, string, this._analyzer, this._tokenizedFieldSet);
        }
        query = LuceneQueryBuilder.constructQueryFromAnalyzedString(this.luceneConfig, string, luceneIndexField, similarity, query, analyzedString, this._tokenizedFieldSet);
        return query;
    }

    private void addProhibitedTextField(String searchParam, String luceneIndexField, BooleanQuery query) {
        BooleanClause booleanClause = null;
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        BooleanClause.Occur dontOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, true);
        if (StringUtils.isNotBlank((String)searchParam)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MatchAllDocsQuery matchAllDocsQuery = new MatchAllDocsQuery();
            BooleanClause matchAllDocsClause = new BooleanClause((Query)matchAllDocsQuery, occur);
            booleanQuery.add(matchAllDocsClause);
            StringTokenizer st = new StringTokenizer(searchParam.trim(), STRING_TOKENIZER_DELIMITER);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Query subQuery = this.textFieldToken(token, luceneIndexField, null);
                if (subQuery == null) continue;
                BooleanClause subClause = new BooleanClause(subQuery, dontOccur);
                booleanQuery.add(subClause);
            }
            booleanClause = new BooleanClause((Query)booleanQuery, occur);
        }
        if (booleanClause != null) {
            query.add(booleanClause);
        }
    }

    private void addNotRequiredTextField(String searchParam, String luceneIndexField, String similarity, BooleanQuery query) {
        BooleanClause booleanClause = null;
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        BooleanClause.Occur tokenOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
        if (StringUtils.isNotBlank((String)searchParam)) {
            if (!this._tokenizedFieldSet.contains(luceneIndexField)) {
                TermQuery termQuery = new TermQuery(new Term(luceneIndexField, searchParam.trim()));
                BooleanClause clause = new BooleanClause((Query)termQuery, occur);
                query.add(clause);
            } else {
                StringTokenizer st = new StringTokenizer(searchParam.trim(), STRING_TOKENIZER_DELIMITER);
                BooleanQuery booleanQuery = new BooleanQuery();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    Query subQuery = this.textFieldToken(token, luceneIndexField, similarity);
                    if (subQuery == null) continue;
                    BooleanClause subClause = new BooleanClause(subQuery, tokenOccur);
                    booleanQuery.add(subClause);
                }
                booleanClause = new BooleanClause((Query)booleanQuery, occur);
            }
        }
        if (booleanClause != null) {
            query.add(booleanClause);
        }
    }

    private void addRequiredTextField(String searchParam, String luceneIndexField, String similarity, BooleanQuery query) {
        BooleanClause booleanClause = null;
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        if (StringUtils.isNotBlank((String)searchParam)) {
            if (!this._tokenizedFieldSet.contains(luceneIndexField)) {
                BooleanClause clause = new BooleanClause(this.textFieldToken(searchParam, luceneIndexField, similarity), occur);
                query.add(clause);
            } else {
                StringTokenizer st = new StringTokenizer(searchParam, STRING_TOKENIZER_DELIMITER);
                if (st.countTokens() == 1) {
                    String token = st.nextToken();
                    Query subQuery = this.textFieldToken(token, luceneIndexField, similarity);
                    if (subQuery != null) {
                        booleanClause = new BooleanClause(subQuery, occur);
                    }
                } else {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        Query subQuery = this.textFieldToken(token, luceneIndexField, similarity);
                        if (subQuery == null) continue;
                        BooleanClause subClause = new BooleanClause(subQuery, occur);
                        booleanQuery.add(subClause);
                    }
                    booleanClause = new BooleanClause((Query)booleanQuery, occur);
                }
            }
        }
        if (booleanClause != null) {
            query.add(booleanClause);
        }
    }

    private void addSeparatedTextField(String text, String separator, String fieldName, BooleanQuery query) {
        if (StringUtils.isNotBlank((String)text)) {
            BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
            for (String token : Splitter.on((String)separator).trimResults().split((CharSequence)text)) {
                Query subQuery = this.textFieldToken(token, fieldName, null);
                if (subQuery == null) continue;
                BooleanClause clause = new BooleanClause(subQuery, occur);
                query.add(clause);
            }
        }
    }

    private void addAnyTextQuery(String any, String similarity, BooleanQuery query) {
        BooleanClause anyClause = null;
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
        if (StringUtils.isNotBlank((String)any) && !this.onlyWildcard(any)) {
            anyClause = this.tokenizeSearchParam(any, similarity, occur, occur);
        }
        if (anyClause != null) {
            query.add(anyClause);
        }
    }

    private void addUUIDQuery(String fieldValue, String similarity, boolean criteriaIsASet, BooleanQuery bq, BooleanQuery query) {
        if (fieldValue.contains(OR_SEPARATOR)) {
            BooleanQuery uuidBooleanQuery = new BooleanQuery();
            this.addSeparatedTextField(fieldValue, OR_SEPARATOR, "_uuid", uuidBooleanQuery);
            BooleanClause booleanClause = new BooleanClause((Query)uuidBooleanQuery, BooleanClause.Occur.MUST);
            if (criteriaIsASet) {
                bq.add(booleanClause);
            } else {
                query.add(booleanClause);
            }
        } else {
            this.addNotRequiredTextField(fieldValue, "_uuid", similarity, criteriaIsASet ? bq : query);
        }
    }

    private void addBBoxQuery(Map<String, Set<String>> searchCriteria, BooleanQuery query) {
        if (!this.spatialCriteriaAdded) {
            Set<String> r = searchCriteria.get("relation");
            Set<String> e = searchCriteria.get("eastBL");
            Set<String> w = searchCriteria.get("westBL");
            Set<String> n = searchCriteria.get("northBL");
            Set<String> s = searchCriteria.get("southBL");
            if (e != null && w != null && n != null && s != null) {
                this.addBoundingBoxQuery(query, (String)r.toArray()[0], (String)e.toArray()[0], (String)w.toArray()[0], (String)n.toArray()[0], (String)s.toArray()[0]);
            }
            this.spatialCriteriaAdded = true;
        }
    }

    private void addPrivilegeQuery(LuceneQueryInput luceneQueryInput, BooleanQuery query) {
        boolean admin;
        String owner;
        Set<String> groups = luceneQueryInput.getGroups();
        Set<String> editableGroups = luceneQueryInput.getEditableGroups();
        BooleanQuery groupsQuery = new BooleanQuery();
        boolean groupsQueryEmpty = true;
        BooleanClause.Occur groupOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
        if (!CollectionUtils.isEmpty(editableGroups)) {
            Log.trace((String)"geonetwork.search", (Object)"We have editable groups to add");
            for (String group : editableGroups) {
                if (!StringUtils.isNotBlank((String)group)) continue;
                Log.trace((String)"geonetwork.search", (Object)(" > Group: " + group));
                TermQuery editQuery = new TermQuery(new Term("_op2", group.trim()));
                BooleanClause editClause = new BooleanClause((Query)editQuery, groupOccur);
                groupsQueryEmpty = false;
                groupsQuery.add(editClause);
            }
        }
        if (!CollectionUtils.isEmpty(groups)) {
            Log.trace((String)"geonetwork.search", (Object)"We have viewable groups to add");
            for (String group : groups) {
                if (!StringUtils.isNotBlank((String)group)) continue;
                Log.trace((String)"geonetwork.search", (Object)(" > Group: " + group));
                TermQuery viewQuery = new TermQuery(new Term("_op0", group.trim()));
                BooleanClause viewClause = new BooleanClause((Query)viewQuery, groupOccur);
                groupsQueryEmpty = false;
                groupsQuery.add(viewClause);
            }
        }
        if ((owner = luceneQueryInput.getOwner()) != null) {
            TermQuery ownerQuery = new TermQuery(new Term("_owner", owner));
            BooleanClause.Occur ownerOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(false, false);
            BooleanClause ownerClause = new BooleanClause((Query)ownerQuery, ownerOccur);
            groupsQueryEmpty = false;
            groupsQuery.add(ownerClause);
        }
        if (admin = luceneQueryInput.getAdmin()) {
            TermQuery adminQuery = new TermQuery(new Term("_dummy", "0"));
            BooleanClause adminClause = new BooleanClause((Query)adminQuery, groupOccur);
            groupsQueryEmpty = false;
            groupsQuery.add(adminClause);
        }
        if (!groupsQueryEmpty) {
            BooleanClause.Occur groupsOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            BooleanClause groupsClause = new BooleanClause((Query)groupsQuery, groupsOccur);
            query.add(groupsClause);
        }
    }

    private void addRangeQuery(BooleanQuery query, String from, String to, String luceneIndexField) {
        if (from == null && to == null) {
            return;
        }
        LuceneConfig.LuceneConfigNumericField type = this._numericFieldSet.get(luceneIndexField);
        if (type == null) {
            this.addTextRangeQuery(query, from, to, luceneIndexField);
        } else {
            this.addNumericRangeQuery(query, from, to, true, true, luceneIndexField, true);
        }
    }

    private void addNumericRangeQuery(BooleanQuery query, String min, String max, boolean minInclusive, boolean maxExclusive, String luceneIndexField, boolean required) {
        if (min != null && max != null) {
            String type = this._numericFieldSet.get(luceneIndexField).getType();
            int precisionStep = this._numericFieldSet.get(luceneIndexField).getPrecisionStep();
            NumericRangeQuery<? extends Number> rangeQuery = LuceneQueryBuilder.buildNumericRangeQueryForType(luceneIndexField, min, max, minInclusive, maxExclusive, type, precisionStep);
            BooleanClause.Occur denoOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(required, false);
            BooleanClause rangeClause = new BooleanClause(rangeQuery, denoOccur);
            query.add(rangeClause);
        }
    }

    public static NumericRangeQuery<? extends Number> buildNumericRangeQueryForType(String fieldName, String min, String max, boolean minInclusive, boolean maxInclusive, String type, int precisionStep) {
        NumericRangeQuery rangeQuery = "double".equals(type) ? NumericRangeQuery.newDoubleRange((String)fieldName, (int)precisionStep, (Double)(min == null ? Double.MIN_VALUE : Double.parseDouble(min)), (Double)(max == null ? Double.MAX_VALUE : Double.parseDouble(max)), (boolean)true, (boolean)true) : ("float".equals(type) ? NumericRangeQuery.newFloatRange((String)fieldName, (int)precisionStep, (Float)Float.valueOf(min == null ? Float.MIN_VALUE : Float.parseFloat(min)), (Float)Float.valueOf(max == null ? Float.MAX_VALUE : Float.parseFloat(max)), (boolean)true, (boolean)true) : ("long".equals(type) ? NumericRangeQuery.newLongRange((String)fieldName, (int)precisionStep, (Long)(min == null ? Long.MIN_VALUE : Long.parseLong(min)), (Long)(max == null ? Long.MAX_VALUE : Long.parseLong(max)), (boolean)true, (boolean)true) : NumericRangeQuery.newIntRange((String)fieldName, (int)precisionStep, (Integer)(min == null ? Integer.MIN_VALUE : Integer.parseInt(min)), (Integer)(max == null ? Integer.MAX_VALUE : Integer.parseInt(max)), (boolean)true, (boolean)true)));
        return rangeQuery;
    }

    private void addTextRangeQuery(BooleanQuery query, String dateFrom, String dateTo, String luceneIndexField) {
        if (StringUtils.isNotBlank((String)dateTo) || StringUtils.isNotBlank((String)dateFrom)) {
            if (dateTo != null && dateTo.length() == 10) {
                dateTo = dateTo + "T23:59:59";
            }
            TermRangeQuery rangeQuery = TermRangeQuery.newStringRange((String)luceneIndexField, (String)dateFrom, (String)dateTo, (boolean)true, (boolean)true);
            BooleanClause.Occur dateOccur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
            BooleanClause dateRangeClause = new BooleanClause((Query)rangeQuery, dateOccur);
            query.add(dateRangeClause);
        }
    }

    private void addLatLongQuery(BooleanQuery query, String westBL, String minWestBL, String maxWestBL, String westBLIndexField, String eastBL, String minEastBL, String maxEastBL, String eastBLIndexField, String southBL, String minSouthBL, String maxSouthBL, String southBLIndexField, String northBL, String minNorthBL, String maxNorthBL, String northBLIndexField, boolean inclusive, boolean required) {
        if (eastBL != null) {
            this.addNumericRangeQuery(query, minEastBL, maxEastBL, inclusive, inclusive, eastBLIndexField, required);
        }
        if (westBL != null) {
            this.addNumericRangeQuery(query, minWestBL, maxWestBL, inclusive, inclusive, westBLIndexField, required);
        }
        if (southBL != null) {
            this.addNumericRangeQuery(query, minSouthBL, maxSouthBL, inclusive, inclusive, southBLIndexField, required);
        }
        if (northBL != null) {
            this.addNumericRangeQuery(query, minNorthBL, maxNorthBL, inclusive, inclusive, northBLIndexField, required);
        }
    }

    private void addBoundingBoxQuery(BooleanQuery query, String relation, String eastBL, String westBL, String northBL, String southBL) {
        boolean inclusive = true;
        if (relation == null || relation.equals("overlaps")) {
            this.addLatLongQuery(query, westBL, westBL, String.valueOf(maxBoundingLongitudeValue), "eastBL", eastBL, String.valueOf(minBoundingLongitudeValue), eastBL, "westBL", southBL, southBL, String.valueOf(maxBoundingLatitudeValue), "northBL", northBL, String.valueOf(minBoundingLatitudeValue), northBL, "southBL", inclusive, true);
        } else if (relation.equals("equal")) {
            this.addLatLongQuery(query, westBL, westBL, westBL, "westBL", eastBL, eastBL, eastBL, "eastBL", southBL, southBL, southBL, "southBL", northBL, northBL, northBL, "northBL", inclusive, true);
        } else if (relation.equals("encloses")) {
            this.addLatLongQuery(query, westBL, String.valueOf(minBoundingLongitudeValue), westBL, "westBL", eastBL, eastBL, String.valueOf(maxBoundingLongitudeValue), "eastBL", southBL, String.valueOf(minBoundingLatitudeValue), southBL, "southBL", northBL, northBL, String.valueOf(maxBoundingLatitudeValue), "northBL", inclusive, true);
        } else if (relation.equals("fullyEnclosedWithin")) {
            this.addLatLongQuery(query, westBL, westBL, eastBL, "westBL", eastBL, westBL, eastBL, "eastBL", southBL, southBL, northBL, "southBL", northBL, southBL, northBL, "northBL", inclusive, true);
        } else if (relation.equals("fullyOutsideOf")) {
            this.addLatLongQuery(query, westBL, String.valueOf(minBoundingLongitudeValue), westBL, "eastBL", eastBL, eastBL, String.valueOf(maxBoundingLongitudeValue), "westBL", southBL, String.valueOf(minBoundingLatitudeValue), southBL, "northBL", northBL, northBL, String.valueOf(maxBoundingLatitudeValue), "southBL", inclusive, false);
        }
    }

    private boolean onlyWildcard(String s) {
        return "*".equals(StringUtils.trim((String)s));
    }

    private static class DrillDownPath {
        private static final String DRILLDOWN_PATH_SEPARATOR = "/";
        private final String dimension;
        private final String[] path;

        public DrillDownPath(String drillDownPath) {
            this.dimension = this.getDimension(drillDownPath);
            this.path = this.getPath(drillDownPath);
        }

        private String getDimension(String drillDownPath) {
            String[] drilldownQueryComponents = drillDownPath.split(DRILLDOWN_PATH_SEPARATOR);
            return drilldownQueryComponents[0];
        }

        private String[] getPath(String drillDownPath) {
            String[] components = drillDownPath.split(DRILLDOWN_PATH_SEPARATOR);
            String[] result = new String[components.length - 1];
            for (int i = 1; i < components.length; ++i) {
                try {
                    result[i - 1] = URLDecoder.decode(components[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        public String getDimension() {
            return this.dimension;
        }

        public String[] getPath() {
            return this.path;
        }
    }
}

