/*
 * Decompiled with CFR 0.152.
 */
package jeeves;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import javax.servlet.ServletContext;
import jeeves.server.overrides.ConfigurationOverrides;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XmlFileCacher {
    private ServletContext servletContext;
    private Path appPath;
    private Path file;
    private int interval;
    private long lastTime;
    private FileTime lastModified;
    private Element elem;

    public XmlFileCacher(Path file, Path appPath) {
        this(file, null, appPath);
    }

    public XmlFileCacher(Path file, ServletContext servletContext, Path appPath) {
        this(file, 10, servletContext, appPath);
    }

    public XmlFileCacher(Path file, int interval, ServletContext servletContext, Path appPath) {
        this.file = file;
        this.interval = interval;
        this.servletContext = servletContext;
        this.appPath = appPath;
    }

    public Element get() throws JDOMException, IOException {
        if (this.elem == null) {
            this.elem = this.load();
            this.lastTime = System.currentTimeMillis();
            this.lastModified = Files.getLastModifiedTime(this.file, new LinkOption[0]);
        } else {
            long now = System.currentTimeMillis();
            int delta = (int)(now - this.lastTime) / 1000;
            if (delta >= this.interval) {
                FileTime fileModified = Files.getLastModifiedTime(this.file, new LinkOption[0]);
                if (!this.lastModified.equals(fileModified)) {
                    this.elem = this.load();
                    this.lastModified = fileModified;
                }
                this.lastTime = now;
            }
        }
        return this.elem;
    }

    protected Element load() throws JDOMException, IOException {
        Element xml = Xml.loadFile((Path)this.file);
        ConfigurationOverrides.DEFAULT.updateWithOverrides(this.file.toString(), this.servletContext, this.appPath, xml);
        return xml;
    }
}

