/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.iterators;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdBNode;
import org.openrdf.sesame.sailimpl.rdbms.model.IdLiteral;
import org.openrdf.sesame.sailimpl.rdbms.model.IdURI;

public class RdbmsStatementIterator
implements StatementIterator {
    private RdfSource _source;
    private String[] _namespaceNames;
    private ResultSet _resultSet;
    private java.sql.Statement _statement;
    private Connection _databaseCon;
    private String _queryResources;
    private String _queryLiterals;
    private boolean _hasNext;
    private Resource _subject;
    private URI _predicate;
    private Value _object;
    private boolean _subjectFixed;
    private boolean _predicateFixed;
    private boolean _objectFixed;
    private boolean _literalsHasBeenQueried;

    public RdbmsStatementIterator(RdfSource source, String[] namespaceNames, Connection databaseCon, String queryResources, String queryLiterals, Resource subject, URI predicate, Value object) {
        this._source = source;
        this._namespaceNames = namespaceNames;
        this._databaseCon = databaseCon;
        this._queryResources = queryResources;
        this._queryLiterals = queryLiterals;
        this._subject = subject;
        this._predicate = predicate;
        this._object = object;
        this._literalsHasBeenQueried = false;
        this._subjectFixed = subject != null;
        this._predicateFixed = predicate != null;
        this._objectFixed = object != null;
        this._execQuery(this._queryResources);
        this._proceed();
    }

    private void _proceed() {
        if (!this._hasNext) {
            if (!this._literalsHasBeenQueried) {
                this._literalsHasBeenQueried = true;
                this._execQuery(this._queryLiterals);
                this._proceed();
            } else {
                this.close();
            }
        }
    }

    private void _execQuery(String query) {
        try {
            if (query != null) {
                if (this._resultSet != null) {
                    this._resultSet.close();
                    this._resultSet = null;
                }
                if (this._statement == null) {
                    this._statement = this._databaseCon.createStatement();
                }
                this._resultSet = this._statement.executeQuery(query);
                this._hasNext = this._resultSet.next();
            } else {
                this._hasNext = false;
            }
        }
        catch (SQLException e) {
            throw new SailInternalException("Unable to execute query: " + query, e);
        }
    }

    public boolean hasNext() {
        return this._hasNext;
    }

    public Statement next() {
        if (!this._hasNext) {
            throw new NoSuchElementException("No more statements...");
        }
        try {
            String localname;
            int nsId;
            int id;
            int idx = 1;
            if (!this._subjectFixed) {
                id = this._resultSet.getInt(idx++);
                nsId = this._resultSet.getInt(idx++);
                if ((localname = this._resultSet.getString(idx++)) == null) {
                    localname = "";
                }
                this._subject = nsId == 0 ? new IdBNode(this._source, localname, id) : new IdURI(this._source, this._namespaceNames[nsId], localname, id);
            }
            if (!this._predicateFixed) {
                id = this._resultSet.getInt(idx++);
                nsId = this._resultSet.getInt(idx++);
                if ((localname = this._resultSet.getString(idx++)) == null) {
                    localname = "";
                }
                this._predicate = new IdURI(this._source, this._namespaceNames[nsId], localname, id);
            }
            if (!this._objectFixed) {
                if (!this._literalsHasBeenQueried) {
                    id = this._resultSet.getInt(idx++);
                    nsId = this._resultSet.getInt(idx++);
                    if ((localname = this._resultSet.getString(idx++)) == null) {
                        localname = "";
                    }
                    this._object = nsId == 0 ? new IdBNode(this._source, localname, id) : new IdURI(this._source, this._namespaceNames[nsId], localname, id);
                } else {
                    String label;
                    id = this._resultSet.getInt(idx++);
                    int dtId = this._resultSet.getInt(idx++);
                    int dtNsId = this._resultSet.getInt(idx++);
                    String dtLname = this._resultSet.getString(idx++);
                    String lang = this._resultSet.getString(idx++);
                    if ((label = this._resultSet.getString(idx++)) == null) {
                        label = "";
                    }
                    if (dtId != 0) {
                        if (dtLname == null) {
                            dtLname = "";
                        }
                        IdURI datatype = new IdURI(this._source, this._namespaceNames[dtNsId], dtLname, dtId);
                        this._object = new IdLiteral(this._source, label, (URI)datatype, id);
                    } else {
                        this._object = lang != null ? new IdLiteral(this._source, label, lang, id) : new IdLiteral(this._source, label, id);
                    }
                }
            }
            this._hasNext = this._resultSet.next();
            this._proceed();
            return new StatementImpl(this._subject, this._predicate, this._object);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void close() {
        if (this._databaseCon != null) {
            try {
                if (this._resultSet != null) {
                    this._resultSet.close();
                    this._resultSet = null;
                }
                if (this._statement != null) {
                    this._statement.close();
                    this._statement = null;
                }
                this._databaseCon.close();
                this._databaseCon = null;
                this._hasNext = false;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
    }

    protected void finalize() {
        this.close();
    }
}

