/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import net.sf.json.JSON;
import net.sf.json.xml.XMLSerializer;
import net.sf.saxon.Controller;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.fao.geonet.Constants;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.utils.CachedTransformer;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.NoOpEntityResolver;
import org.fao.geonet.utils.Resolver;
import org.fao.geonet.utils.ResolverWrapper;
import org.fao.geonet.utils.TransformerFactoryFactory;
import org.fao.geonet.utils.XmlErrorHandler;
import org.fao.geonet.utils.nio.NioPathAwareEntityResolver;
import org.fao.geonet.utils.nio.NioPathHolder;
import org.fao.geonet.utils.nio.PathStreamSource;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.SAXOutputter;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.mozilla.universalchardet.UniversalDetector;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class Xml {
    public static final Namespace xsiNS = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final NioPathAwareEntityResolver PATH_RESOLVER = new NioPathAwareEntityResolver();

    private static SAXBuilder getSAXBuilder(boolean validate, Path base) {
        SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(validate, base);
        Resolver resolver = ResolverWrapper.getInstance();
        builder.setEntityResolver((EntityResolver)((Object)resolver.getXmlResolver()));
        return builder;
    }

    private static SAXBuilder getSAXBuilderWithPathXMLResolver(boolean validate, Path base) {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        if (base != null) {
            NioPathHolder.setBase(base);
            builder.setEntityResolver((EntityResolver)PATH_RESOLVER);
        } else {
            builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        }
        return builder;
    }

    public static void resetResolver() {
        Resolver resolver = ResolverWrapper.getInstance();
        resolver.reset();
    }

    public static Element loadFile(URL url) throws IOException, JDOMException {
        Path path = Xml.pathFromUrl(url);
        SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(false, path);
        Document jdoc = builder.build(url);
        return (Element)jdoc.getRootElement().detach();
    }

    protected static Path pathFromUrl(URL url) {
        Path path = null;
        try {
            path = IO.toPath(url.toURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static Element loadFile(URL url, Element xmlQuery) throws IOException, JDOMException {
        Element result = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/xml");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(Xml.getString(xmlQuery).getBytes(Constants.ENCODING).length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setDoOutput(true);
            PrintStream out = new PrintStream(connection.getOutputStream(), true, Constants.ENCODING);
            out.print(Xml.getString(xmlQuery));
            out.close();
            Path path = Xml.pathFromUrl(url);
            SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(false, path);
            Document jdoc = builder.build(connection.getInputStream());
            result = (Element)jdoc.getRootElement().detach();
        }
        catch (Exception e) {
            Log.error("jeeves.engine", "Error loading URL " + url.getPath() + " .Threw exception " + e.getMessage(), e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element loadFile(Path file) throws JDOMException, NoSuchFileException {
        try {
            SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(false, file);
            String convert = System.getProperty("jeeves.filecharsetdetectandconvert", "");
            if (convert.equals("enabled")) {
                byte[] content = Xml.convertFileToUTF8ByteArray(file);
                return Xml.loadStream(new ByteArrayInputStream(content));
            }
            try (InputStream in = IO.newInputStream(file);){
                Document jdoc = builder.build(in);
                Element element = (Element)jdoc.getRootElement().detach();
                return element;
            }
        }
        catch (JDOMException e) {
            throw new JDOMException("Error occurred while trying to load an xml file: " + file, (Throwable)e);
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error occurred while trying to load an xml file: " + file, e);
        }
    }

    public static synchronized byte[] convertFileToUTF8ByteArray(Path file) throws IOException {
        try (DataInputStream inStream = new DataInputStream(IO.newInputStream(file));){
            byte[] buf = new byte[(int)Files.size(file)];
            int nrRead = inStream.read(buf);
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(buf, 0, nrRead);
            detector.dataEnd();
            String encoding = detector.getDetectedCharset();
            detector.reset();
            if (encoding != null && !encoding.equals(Constants.ENCODING)) {
                Log.error("jeeves", "Detected character set " + encoding + ", converting to UTF-8");
                byte[] byArray = Xml.convertByteArrayToUTF8ByteArray(buf, encoding);
                return byArray;
            }
            byte[] byArray = buf;
            return byArray;
        }
    }

    public static synchronized byte[] convertByteArrayToUTF8ByteArray(byte[] buf, String charsetName) throws CharacterCodingException {
        Charset cset = Charset.forName(charsetName);
        CharsetDecoder csetDecoder = cset.newDecoder();
        Charset utf8 = Charset.forName(Constants.ENCODING);
        CharsetEncoder utf8Encoder = utf8.newEncoder();
        ByteBuffer inputBuffer = ByteBuffer.wrap(buf);
        CharBuffer data = csetDecoder.decode(inputBuffer);
        ByteBuffer outputBuffer = utf8Encoder.encode(data);
        byte[] out = outputBuffer.array();
        int length = out.length;
        while (out[length - 1] == 0) {
            --length;
        }
        byte[] result = new byte[length];
        System.arraycopy(out, 0, result, 0, length);
        return result;
    }

    public static Element loadString(String data, boolean validate) throws IOException, JDOMException {
        try {
            SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(validate, null);
            Document jdoc = builder.build((Reader)new StringReader(data));
            return (Element)jdoc.getRootElement().detach();
        }
        catch (Exception e) {
            Log.warning("jeeves.xmlresolver", String.format("Error loading string %s as XML. Error is: %s", data, e.getMessage()));
            throw e;
        }
    }

    public static Element loadStream(InputStream input) throws IOException, JDOMException {
        SAXBuilder builder = Xml.getSAXBuilderWithPathXMLResolver(false, null);
        builder.setFeature("http://apache.org/xml/features/validation/schema", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document jdoc = builder.build(input);
        return (Element)jdoc.getRootElement().detach();
    }

    public static Element transform(Element xml, Path styleSheetPath) throws Exception {
        JDOMResult resXml = new JDOMResult();
        Xml.transform(xml, styleSheetPath, (Result)resXml, null);
        return (Element)resXml.getDocument().getRootElement().detach();
    }

    public static Object unmarshall(Element xml, Class clazz) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        StreamSource source = new StreamSource(new StringReader(Xml.getString(xml)));
        return jaxbUnmarshaller.unmarshal((Source)source);
    }

    public static Element transform(Element xml, Path styleSheetPath, Map<String, Object> params) throws Exception {
        JDOMResult resXml = new JDOMResult();
        Xml.transform(xml, styleSheetPath, (Result)resXml, params);
        return (Element)resXml.getDocument().getRootElement().detach();
    }

    public static void transform(Element xml, Path styleSheetPath, OutputStream out) throws Exception {
        StreamResult resStream = new StreamResult(out);
        Xml.transform(xml, styleSheetPath, resStream, null);
        out.flush();
    }

    public static void transformXml(Element xml, Path styleSheetPath, OutputStream out) throws Exception {
        StreamResult resStream = new StreamResult(out);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("geonet-force-xml", "xml");
        Xml.transform(xml, styleSheetPath, resStream, map);
        out.flush();
    }

    public static void transform(Element xml, String styleSheetPath, Result result) throws Exception {
        Xml.transform(xml, IO.toPath(styleSheetPath, new String[0]), result, null);
    }

    public static Element transformWithXmlParam(Element xml, String styleSheetPath, String xmlParamName, String xmlParam) throws Exception {
        JDOMResult resXml = new JDOMResult();
        File styleSheet = new File(styleSheetPath);
        StreamSource srcSheet = new StreamSource(styleSheet);
        Xml.transformWithXmlParam(xml, srcSheet, (Result)resXml, xmlParamName, xmlParam);
        return (Element)resXml.getDocument().getRootElement().detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformWithXmlParam(Element xml, Source xslt, Result result, String xmlParamName, String xmlParam) throws Exception {
        JDOMSource srcXml = new JDOMSource(new Document((Element)xml.detach()));
        TransformerFactory transFact = TransformerFactoryFactory.getTransformerFactory();
        try {
            transFact.setAttribute("http://saxon.sf.net/feature/version-warning", false);
            transFact.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
            transFact.setAttribute("http://saxon.sf.net/feature/preEvaluateDocFunction", true);
            transFact.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", 0);
        }
        catch (IllegalArgumentException e) {
            Log.warning("jeeves.engine", "WARNING: transformerfactory doesnt like saxon attributes!", e);
        }
        finally {
            Transformer t = transFact.newTransformer(xslt);
            if (xmlParam != null) {
                t.setParameter(xmlParamName, new StreamSource(new StringReader(xmlParam)));
            }
            t.transform((Source)srcXml, result);
        }
    }

    protected static Path resolvePath(Source s) throws URISyntaxException {
        Path f;
        String systemId = s.getSystemId().replaceAll("%5C", "/");
        try {
            f = IO.toPath(new URI(systemId));
        }
        catch (FileSystemNotFoundException e) {
            f = IO.toPath(systemId, new String[0]);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(Element xml, Path styleSheetPath, Result result, Map<String, Object> params) throws Exception {
        NioPathHolder.setBase(styleSheetPath);
        JDOMSource srcXml = new JDOMSource(new Document((Element)xml.detach()));
        try (InputStream in = IO.newInputStream(styleSheetPath);){
            StreamSource srcSheet = new StreamSource(in, styleSheetPath.toUri().toASCIIString());
            TransformerFactory transFact = TransformerFactoryFactory.getTransformerFactory();
            transFact.setURIResolver(new JeevesURIResolver());
            try {
                transFact.setAttribute("http://saxon.sf.net/feature/version-warning", false);
                transFact.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
                transFact.setAttribute("http://saxon.sf.net/feature/preEvaluateDocFunction", false);
                transFact.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", 0);
            }
            catch (IllegalArgumentException e) {
                Log.warning("jeeves.engine", "WARNING: transformerfactory doesnt like saxon attributes!", e);
            }
            finally {
                transFact.setURIResolver(new JeevesURIResolver());
                Transformer t = transFact.newTransformer(srcSheet);
                if (params != null) {
                    for (Map.Entry<String, Object> param : params.entrySet()) {
                        t.setParameter(param.getKey(), param.getValue());
                    }
                    if (params.containsKey("geonet-force-xml")) {
                        ((Controller)t).setOutputProperty("indent", "yes");
                        ((Controller)t).setOutputProperty("method", "xml");
                        ((Controller)t).setOutputProperty("{http://saxon.sf.net/}indent-spaces", "3");
                    }
                }
                t.transform((Source)srcXml, result);
            }
        }
    }

    public static void clearTransformerFactoryStylesheetCache() {
        TransformerFactory transFact = TransformerFactory.newInstance();
        if (transFact instanceof CachedTransformer) {
            ((CachedTransformer)((Object)transFact)).clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path transformFOP(Path uploadDir, Element xml, String styleSheetPath) throws Exception {
        Path file = uploadDir.resolve(UUID.randomUUID().toString() + ".pdf");
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)bufferedOut);
            TransformerFactory factory = TransformerFactoryFactory.getTransformerFactory();
            factory.setURIResolver(new JeevesURIResolver());
            StreamSource xslt = new StreamSource(new File(styleSheetPath));
            try {
                factory.setAttribute("http://saxon.sf.net/feature/version-warning", false);
                factory.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
                factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", 0);
            }
            catch (IllegalArgumentException e) {
                Log.warning("jeeves.engine", "WARNING: transformerfactory doesnt like saxon attributes!", e);
            }
            finally {
                Transformer transformer = factory.newTransformer(xslt);
                JDOMSource src = new JDOMSource(new Document((Element)xml.detach()));
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform((Source)src, res);
            }
        }
        return file;
    }

    public static void writeResponse(Document doc, OutputStream out) throws IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, out);
    }

    public static String getString(Element data) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(data);
    }

    public static String getJSON(Element xml) throws IOException {
        return Xml.getJSON(Xml.getString(xml));
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static Element getXmlFromJSON(String jsonAsString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode json = objectMapper.readTree(jsonAsString);
            String recordAsXml = XML.toString((Object)new JSONObject(objectMapper.writeValueAsString((Object)json)), (String)"root");
            recordAsXml = Xml.stripNonValidXMLCharacters(recordAsXml);
            return Xml.loadString(recordAsXml, false);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getJSON(String xml) throws IOException {
        XMLSerializer xmlSerializer = new XMLSerializer();
        xmlSerializer.setTypeHintsEnabled(false);
        xmlSerializer.setTypeHintsCompatibility(false);
        JSON json = xmlSerializer.read(xml);
        return json.toString(2);
    }

    public static String getString(DocType data) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(data);
    }

    public static String getString(Document data) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(data);
    }

    private static XPath prepareXPath(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = XPath.newInstance((String)xpath);
        for (Namespace ns : theNSs) {
            xp.addNamespace(ns);
        }
        return xp;
    }

    public static Object selectSingle(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = Xml.prepareXPath(xml, xpath, theNSs);
        return xp.selectSingleNode((Object)xml);
    }

    public static Element selectElement(Element xml, String xpath) throws JDOMException {
        return Xml.selectElement(xml, xpath, new ArrayList<Namespace>());
    }

    public static Element selectElement(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        Object result = Xml.selectSingle(xml, xpath, theNSs);
        if (result == null) {
            return null;
        }
        if (result instanceof Element) {
            Element elem = (Element)result;
            return elem;
        }
        return null;
    }

    public static List<?> selectNodes(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = Xml.prepareXPath(xml, xpath, theNSs);
        return xp.selectNodes((Object)xml);
    }

    public static List<?> selectDocumentNodes(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = XPath.newInstance((String)xpath);
        for (Namespace ns : theNSs) {
            xp.addNamespace(ns);
        }
        xml = (Element)xml.clone();
        Document document = new Document(xml);
        return xp.selectNodes((Object)document);
    }

    public static List<?> selectNodes(Element xml, String xpath) throws JDOMException {
        return Xml.selectNodes(xml, xpath, new ArrayList<Namespace>());
    }

    public static String selectString(Element xml, String xpath) throws JDOMException {
        return Xml.selectString(xml, xpath, new ArrayList<Namespace>());
    }

    public static String selectString(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = Xml.prepareXPath(xml, xpath, theNSs);
        return xp.valueOf((Object)xml);
    }

    public static boolean selectBoolean(Element xml, String xpath) throws JDOMException {
        String result = Xml.selectString(xml, xpath, new ArrayList<Namespace>());
        return result.length() > 0;
    }

    public static boolean selectBoolean(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        return Xml.selectString(xml, xpath, theNSs).length() > 0;
    }

    public static Number selectNumber(Element xml, String xpath) throws JDOMException {
        return Xml.selectNumber(xml, xpath, new ArrayList<Namespace>());
    }

    public static Number selectNumber(Element xml, String xpath, List<Namespace> theNSs) throws JDOMException {
        XPath xp = Xml.prepareXPath(xml, xpath, theNSs);
        return xp.numberValueOf((Object)xml);
    }

    public static Set<String> filterElementValues(Element element, ElementFilter elementFilter, String elementName, Namespace elementNamespace, String attributeName) {
        return Xml.filterElementValues(element, elementFilter, elementName, elementNamespace, attributeName, null);
    }

    public static Set<String> filterElementValues(Element element, ElementFilter elementFilter, String elementName, Namespace elementNamespace, String attributeName, Namespace attributeNamespace) {
        Iterator i = element.getDescendants((Filter)elementFilter);
        HashSet<String> values = new HashSet<String>();
        boolean first = true;
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String uuid = elementName == null && attributeName == null ? e.getText() : (attributeName == null ? e.getChildText(elementName, elementNamespace) : (attributeNamespace == null ? e.getAttributeValue(attributeName) : e.getAttributeValue(attributeName, attributeNamespace)));
            if (uuid == null || uuid.isEmpty()) continue;
            values.add(uuid);
        }
        return values;
    }

    public static synchronized void validate(Element xml) throws Exception {
        String schemaLoc = xml.getAttributeValue("schemaLocation", xsiNS);
        if (schemaLoc == null || schemaLoc.equals("")) {
            throw new IllegalArgumentException("XML document missing/blank schemaLocation hints - cannot validate");
        }
        XmlErrorHandler eh = new XmlErrorHandler();
        Schema schema = Xml.factory().newSchema();
        Element xsdErrors = Xml.validateRealGuts(schema, xml, eh, null);
        if (xsdErrors != null) {
            throw new XSDValidationErrorEx("XSD Validation error(s):\n" + Xml.getString(xsdErrors), xsdErrors);
        }
    }

    public static void validate(Path schemaPath, Element xml) throws Exception {
        XmlErrorHandler eh = new XmlErrorHandler();
        Schema schema = Xml.getSchemaFromPath(schemaPath);
        Element xsdErrors = Xml.validateRealGuts(schema, xml, eh, null);
        if (xsdErrors != null) {
            throw new XSDValidationErrorEx("XSD Validation error(s):\n" + Xml.getString(xsdErrors), xsdErrors);
        }
    }

    public static Element validateInfo(Element xml, XmlErrorHandler eh, String schemaName) throws Exception {
        Schema schema = Xml.factory().newSchema();
        return Xml.validateRealGuts(schema, xml, eh, schemaName);
    }

    public static Element validateInfo(Path schemaPath, Element xml, XmlErrorHandler eh, String schemaName) throws Exception {
        Schema schema = Xml.getSchemaFromPath(schemaPath);
        return Xml.validateRealGuts(schema, xml, eh, schemaName);
    }

    private static Schema getSchemaFromPath(Path schemaPath) throws SAXException {
        PathStreamSource schemaFile = new PathStreamSource(schemaPath);
        schemaFile.setSystemId(schemaPath.toUri().toASCIIString());
        SchemaFactory factory = Xml.factory();
        NioPathHolder.setBase(schemaPath);
        Resolver resolver = ResolverWrapper.getInstance();
        factory.setResourceResolver((LSResourceResolver)((Object)resolver.getXmlResolver()));
        return factory.newSchema(schemaFile);
    }

    private static Element validateRealGuts(Schema schema, Element xml, XmlErrorHandler eh, String schemaName) throws JDOMException {
        Resolver resolver = ResolverWrapper.getInstance(schemaName);
        ValidatorHandler vh = schema.newValidatorHandler();
        vh.setResourceResolver((LSResourceResolver)((Object)resolver.getXmlResolver()));
        vh.setErrorHandler(eh);
        SAXOutputter so = new SAXOutputter((ContentHandler)vh);
        eh.setSo(so);
        so.output(xml);
        if (eh.errors()) {
            return eh.getXPaths();
        }
        return null;
    }

    private static SchemaFactory factory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public static String getXPathExpr(Content element) {
        StringBuilder builder = new StringBuilder();
        if (!Xml.doCreateXpathExpr(element, builder)) {
            return null;
        }
        return builder.toString();
    }

    public static String getXPathExpr(Attribute attribute) {
        StringBuilder builder = new StringBuilder();
        if (!Xml.doCreateXpathExpr(attribute, builder)) {
            return null;
        }
        return builder.toString();
    }

    private static boolean doCreateXpathExpr(Object content, StringBuilder builder) {
        Element parentElement;
        if (builder.length() > 0) {
            builder.insert(0, "/");
        }
        if (content instanceof Element) {
            Element element = (Element)content;
            List attributes = element.getAttributes();
            Xml.doCreateAttributesXpathExpr(builder, attributes);
            String textTrim = element.getTextTrim();
            if (!textTrim.isEmpty()) {
                boolean addToCondition;
                boolean bl = addToCondition = builder.length() > 0 && builder.charAt(0) == '[';
                if (!addToCondition) {
                    builder.insert(0, "']");
                } else {
                    builder.deleteCharAt(0);
                    builder.insert(0, "' and ");
                }
                builder.insert(0, textTrim).insert(0, "[normalize-space(text()) = '");
            }
            builder.insert(0, element.getName());
            if (element.getNamespacePrefix() != null && !element.getNamespacePrefix().trim().isEmpty()) {
                builder.insert(0, ':').insert(0, element.getNamespacePrefix());
            }
            parentElement = element.getParentElement();
        } else if (content instanceof Text) {
            Text text = (Text)content;
            builder.insert(0, "text()");
            parentElement = text.getParentElement();
        } else if (content instanceof Attribute) {
            Attribute attribute = (Attribute)content;
            builder.insert(0, attribute.getName());
            if (attribute.getNamespacePrefix() != null && !attribute.getNamespacePrefix().trim().isEmpty()) {
                builder.insert(0, ':').insert(0, attribute.getNamespacePrefix());
            }
            builder.insert(0, '@');
            parentElement = attribute.getParent();
        } else {
            parentElement = null;
        }
        if (parentElement != null && parentElement.getParentElement() != null) {
            return Xml.doCreateXpathExpr(parentElement, builder);
        }
        return true;
    }

    private static void doCreateAttributesXpathExpr(StringBuilder builder, List<Attribute> attributes) {
        if (!attributes.isEmpty()) {
            StringBuilder attBuilder = new StringBuilder("[");
            for (Attribute attribute : attributes) {
                if (attBuilder.length() > 1) {
                    attBuilder.append(" and ");
                }
                attBuilder.append('@');
                if (attribute.getNamespacePrefix() != null && !attribute.getNamespacePrefix().trim().isEmpty()) {
                    attBuilder.append(attribute.getNamespacePrefix()).append(':');
                }
                attBuilder.append(attribute.getName()).append(" = '").append(attribute.getValue()).append('\'');
            }
            attBuilder.append("]");
            builder.insert(0, attBuilder);
        }
    }

    public static boolean isXMLLike(String inXMLStr) {
        boolean retBool = false;
        String XML_PATTERN_STR = "<(\\S+?)(.*?)>(.*?)</\\1>";
        if (inXMLStr != null && inXMLStr.trim().length() > 0 && inXMLStr.trim().startsWith("<")) {
            Pattern pattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>", 42);
            Matcher matcher = pattern.matcher(inXMLStr);
            retBool = matcher.matches();
        }
        return retBool;
    }

    private static class JeevesURIResolver
    implements URIResolver {
        private JeevesURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            boolean isFile;
            Resolver resolver = ResolverWrapper.getInstance();
            CatalogResolver catResolver = resolver.getCatalogResolver();
            if (Log.isDebugEnabled("jeeves.xmlresolver")) {
                Log.debug("jeeves.xmlresolver", "Trying to resolve " + href + ":" + base);
            }
            Source s = catResolver.resolve(href, base);
            try {
                Path file = IO.toPath(new URI(s.getSystemId()));
                isFile = Files.isRegularFile(file, new LinkOption[0]);
            }
            catch (Exception e) {
                isFile = false;
            }
            String blankXSLFile = resolver.getBlankXSLFile();
            if (blankXSLFile != null && s.getSystemId().endsWith(".xsl") && !isFile) {
                try {
                    if (Log.isDebugEnabled("jeeves.xmlresolver")) {
                        Log.debug("jeeves.xmlresolver", "  Check if exist " + s.getSystemId());
                    }
                    Path f = Xml.resolvePath(s);
                    if (Log.isDebugEnabled("jeeves.xmlresolver")) {
                        Log.debug("jeeves.xmlresolver", "Check on " + f + " exists returned: " + Files.exists(f, new LinkOption[0]));
                    }
                    if (!Files.exists(f, new LinkOption[0])) {
                        if (Log.isDebugEnabled("jeeves.xmlresolver")) {
                            Log.debug("jeeves.xmlresolver", "  Resolved resource " + s.getSystemId() + " does not exist. blankXSLFile returned instead.");
                        }
                        s.setSystemId(blankXSLFile);
                    } else {
                        s.setSystemId(f.toUri().toASCIIString());
                    }
                }
                catch (URISyntaxException e) {
                    Log.warning("jeeves.xmlresolver", "URI syntax problem: " + e.getMessage(), e);
                }
            }
            if (Log.isDebugEnabled("jeeves.xmlresolver") && s != null) {
                Log.debug("jeeves.xmlresolver", "Resolved as " + s.getSystemId());
            }
            return s;
        }
    }
}

