/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

public final class MonotonicAppendingLongBuffer
extends AbstractAppendingLongBuffer {
    float[] averages;
    long[] minValues;

    public MonotonicAppendingLongBuffer(int initialPageCount, int pageSize, float acceptableOverheadRatio) {
        super(initialPageCount, pageSize, acceptableOverheadRatio);
        this.averages = new float[this.values.length];
        this.minValues = new long[this.values.length];
    }

    public MonotonicAppendingLongBuffer() {
        this(16, 1024, 0.25f);
    }

    public MonotonicAppendingLongBuffer(float acceptableOverheadRatio) {
        this(16, 1024, acceptableOverheadRatio);
    }

    @Override
    long get(int block, int element) {
        if (block == this.valuesOff) {
            return this.pending[element];
        }
        return MonotonicBlockPackedReader.expected(this.minValues[block], this.averages[block], element) + this.values[block].get(element);
    }

    @Override
    int get(int block, int element, long[] arr, int off, int len) {
        if (block == this.valuesOff) {
            int sysCopyToRead = Math.min(len, this.pendingOff - element);
            System.arraycopy(this.pending, element, arr, off, sysCopyToRead);
            return sysCopyToRead;
        }
        int read = this.values[block].get(element, arr, off, len);
        int r = 0;
        while (r < read) {
            int n = off++;
            arr[n] = arr[n] + MonotonicBlockPackedReader.expected(this.minValues[block], this.averages[block], element);
            ++r;
            ++element;
        }
        return read;
    }

    @Override
    void grow(int newBlockCount) {
        super.grow(newBlockCount);
        this.averages = Arrays.copyOf(this.averages, newBlockCount);
        this.minValues = Arrays.copyOf(this.minValues, newBlockCount);
    }

    @Override
    void packPendingValues() {
        int i;
        assert (this.pendingOff > 0);
        float average = this.pendingOff == 1 ? 0.0f : (float)(this.pending[this.pendingOff - 1] - this.pending[0]) / (float)(this.pendingOff - 1);
        long minValue = this.pending[0];
        for (i = 1; i < this.pendingOff; ++i) {
            long actual = this.pending[i];
            long expected = MonotonicBlockPackedReader.expected(minValue, average, i);
            if (expected <= actual) continue;
            minValue -= expected - actual;
        }
        this.minValues[this.valuesOff] = minValue;
        this.averages[this.valuesOff] = average;
        for (i = 0; i < this.pendingOff; ++i) {
            this.pending[i] = this.pending[i] - MonotonicBlockPackedReader.expected(minValue, average, i);
        }
        long maxDelta = 0L;
        for (int i2 = 0; i2 < this.pendingOff; ++i2) {
            if (this.pending[i2] < 0L) {
                maxDelta = -1L;
                break;
            }
            maxDelta = Math.max(maxDelta, this.pending[i2]);
        }
        if (maxDelta == 0L) {
            this.values[this.valuesOff] = new PackedInts.NullReader(this.pendingOff);
        } else {
            int bitsRequired = PackedInts.unsignedBitsRequired(maxDelta);
            PackedInts.Mutable mutable = PackedInts.getMutable(this.pendingOff, bitsRequired, this.acceptableOverheadRatio);
            for (int i3 = 0; i3 < this.pendingOff; i3 += mutable.set(i3, this.pending, i3, this.pendingOff - i3)) {
            }
            this.values[this.valuesOff] = mutable;
        }
    }

    @Override
    long baseRamBytesUsed() {
        return super.baseRamBytesUsed() + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + RamUsageEstimator.sizeOf(this.averages) + RamUsageEstimator.sizeOf(this.minValues);
    }
}

