/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_numberFormat
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("numberFormat", String.class, FunctionNameImpl.parameter("format", String.class), FunctionNameImpl.parameter("number", Number.class));
    public static DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);

    public FilterFunction_numberFormat() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        Double number;
        String format;
        try {
            format = (String)this.getExpression(0).evaluate(feature, String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function dateFormat argument #0 - expected type String");
        }
        try {
            number = (Double)this.getExpression(1).evaluate(feature, Double.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function dateFormat argument #1 - expected type java.util.Date");
        }
        if (format == null || number == null) {
            return null;
        }
        DecimalFormat numberFormat = new DecimalFormat(format, decimalFormatSymbols);
        return numberFormat.format(number);
    }
}

