/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util.provider;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;
import ro.isdc.wro.model.resource.support.hash.HashStrategyProvider;
import ro.isdc.wro.model.resource.support.naming.NamingStrategyProvider;
import ro.isdc.wro.util.provider.ConfigurableProvider;
import ro.isdc.wro.util.provider.ProviderFinder;

public class TestProviderFinder {
    private ProviderFinder<?> victim;

    @Test
    public void shouldFindConfigurableProviders() {
        this.victim = ProviderFinder.of(ConfigurableProvider.class);
        Assert.assertEquals((long)2L, (long)this.victim.find().size());
    }

    @Test
    public void shouldFindProcessorsProvider() {
        this.victim = ProviderFinder.of(ProcessorProvider.class);
        Assert.assertEquals((long)4L, (long)this.victim.find().size());
    }

    @Test
    public void shouldFindNamingStrategyProviders() {
        this.victim = ProviderFinder.of(NamingStrategyProvider.class);
        Assert.assertEquals((long)2L, (long)this.victim.find().size());
    }

    @Test
    public void shouldFindHashBuilderProviders() {
        this.victim = ProviderFinder.of(HashStrategyProvider.class);
        Assert.assertEquals((long)2L, (long)this.victim.find().size());
    }

    @Test
    public void shouldNotFindProviderWhenNoneIsAvailable() {
        this.victim = new ProviderFinder<ProcessorProvider>(ProcessorProvider.class){

            <F> Iterator<F> lookupProviders(Class<F> clazz) {
                return new ArrayList().iterator();
            }
        };
        Assert.assertTrue((boolean)this.victim.find().isEmpty());
    }

    @Test(expected=WroRuntimeException.class)
    public void cannotFindAnyProviderWhenLookupFails() {
        this.victim = new ProviderFinder<ProcessorProvider>(ProcessorProvider.class){

            <F> Iterator<F> lookupProviders(Class<F> clazz) {
                throw new IllegalStateException("BOOM!");
            }
        };
        this.victim.find();
    }
}

