/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;

public class HandleFaultInterceptor
extends DelegateAsyncProcessor {
    public HandleFaultInterceptor() {
    }

    public HandleFaultInterceptor(Processor processor) {
        super(processor);
    }

    @Override
    public String toString() {
        return "HandleFaultInterceptor[" + this.processor + "]";
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    HandleFaultInterceptor.this.handleFault(exchange);
                }
                finally {
                    callback.done(doneSync);
                }
            }
        });
    }

    protected void handleFault(Exchange exchange) {
        Object faultBody;
        if (exchange.hasOut() && exchange.getOut().isFault() && (faultBody = exchange.getOut().getBody()) != null && exchange.getException() == null) {
            exchange.setOut(null);
            if (faultBody instanceof Throwable) {
                exchange.setException((Throwable)faultBody);
            } else {
                String data = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, faultBody);
                exchange.setException(new CamelException(data));
            }
        }
    }
}

