/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.GeometryCollection;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.GenericGeometryEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class GeometryCollectionEncoder
extends GeometryEncoder<GeometryCollection> {
    static final QualifiedName GEOMETRY_COLLECTION = new QualifiedName("http://www.opengis.net/gml", "GeometryCollection", "gml");
    QualifiedName element;
    static Encoder encoder;

    public GeometryCollectionEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        this(encoder, GEOMETRY_COLLECTION.derive(gmlPrefix, gmlUri));
    }

    public GeometryCollectionEncoder(Encoder encoder, QualifiedName name) {
        super(encoder);
        GeometryCollectionEncoder.encoder = encoder;
    }

    public void encode(GeometryCollection geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(GEOMETRY_COLLECTION, (Attributes)atts);
        if (geometry.getNumGeometries() < 1) {
            throw new Exception("More than 1 geometry required!");
        }
        GenericGeometryEncoder gec = new GenericGeometryEncoder(encoder);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            gec.encode(geometry.getGeometryN(i), atts, handler);
        }
        handler.endElement(GEOMETRY_COLLECTION);
    }
}

