/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.gml3.bindings.LineStringTypeBinding;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class CurveTypeBinding
extends AbstractComplexBinding
implements Comparable {
    protected GeometryFactory gf;
    ArcParameters arcParameters;

    public CurveTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    public void setArcParameters(ArcParameters arcParameters) {
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.CurveType;
    }

    public Class getType() {
        return CurvedGeometry.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString[] segments = (LineString[])node.getChildValue("segments");
        if (segments.length == 0) {
            return null;
        }
        if (segments.length == 1) {
            return segments[0];
        }
        LineString curved = null;
        for (LineString ls : segments) {
            if (!(ls instanceof CurvedGeometry)) continue;
            curved = ls;
        }
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gf, curved != null ? curved.getCoordinateSequence() : null);
        return factory.createCurvedGeometry(Arrays.asList(segments));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("segments".equals(name.getLocalPart())) {
            if (object instanceof CompoundCurvedGeometry) {
                CompoundCurvedGeometry curve = (CompoundCurvedGeometry)object;
                List<LineString> components = curve.getComponents();
                return components;
            }
            return object;
        }
        super.getProperty(object, name);
        return null;
    }

    public int compareTo(Object o) {
        if (o instanceof LineStringTypeBinding) {
            return -1;
        }
        return 0;
    }
}

