/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.OwsUtils;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class WFSHarvesterExchangeState {
    Logger logger = Logger.getLogger((String)"geonetwork.harvest.wfs.features");
    private WFSHarvesterParameter parameters;
    private Map<String, String> fields = new LinkedHashMap<String, String>();
    private WFSDataStore wfsDatastore = null;

    public WFSHarvesterParameter getParameters() {
        return this.parameters;
    }

    public void setParameters(WFSHarvesterParameter parameters) {
        this.parameters = parameters;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public void setWfsDatastore(WFSDataStore wfsDatastore) {
        this.wfsDatastore = wfsDatastore;
    }

    public WFSDataStore getWfsDatastore() {
        return this.wfsDatastore;
    }

    WFSHarvesterExchangeState(WFSHarvesterParameter parameters) {
        this.parameters = parameters;
        this.checkTaskParameters();
    }

    private void checkTaskParameters() {
        this.logger.info((Object)"Checking parameters ...");
        if (StringUtils.isEmpty((String)this.parameters.getUrl())) {
            String errorMsg = "Empty WFS server URL is not allowed.";
            this.logger.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (StringUtils.isEmpty((String)this.parameters.getTypeName())) {
            String errorMsg = "Empty WFS type name is not allowed.";
            this.logger.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        this.logger.info((Object)"Parameters are accepted.");
    }

    public void initDataStore() throws Exception {
        WFSDataStoreFactory factory = new WFSDataStoreFactory();
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            String getCapUrl = OwsUtils.getGetCapabilitiesUrl(this.parameters.getUrl(), this.parameters.getVersion());
            this.logger.info((Object)String.format("Connecting using GetCatapbilities URL '%s'.", getCapUrl));
            m.put(WFSDataStoreFactory.URL.key, getCapUrl);
            m.put(WFSDataStoreFactory.TIMEOUT.key, this.parameters.getTimeOut());
            m.put(WFSDataStoreFactory.TRY_GZIP.key, true);
            m.put(WFSDataStoreFactory.ENCODING.key, this.parameters.getEncoding());
            m.put(WFSDataStoreFactory.USEDEFAULTSRS.key, false);
            m.put(WFSDataStoreFactory.OUTPUTFORMAT.key, "GML3");
            m.put(WFSDataStoreFactory.LENIENT.key, true);
            if (this.parameters.getMaxFeatures() != -1) {
                m.put(WFSDataStoreFactory.MAXFEATURES.key, this.parameters.getMaxFeatures());
            }
            this.wfsDatastore = factory.createDataStore(m);
            this.logger.info((Object)String.format("Reading feature type '%s' schema structure.", this.parameters.getTypeName()));
            SimpleFeatureType sft = this.wfsDatastore.getSchema(this.parameters.getTypeName());
            List attributesDesc = sft.getAttributeDescriptors();
            for (AttributeDescriptor desc : attributesDesc) {
                this.fields.put(desc.getName().getLocalPart(), OwsUtils.getTypeFromFeatureType(desc));
            }
            this.logger.info((Object)String.format("Successfully analyzed %d attributes in schema.", this.fields.size()));
        }
        catch (IOException e) {
            String errorMsg = String.format("Failed to create datastore from service using URL '%s'. Error is %s.", this.parameters.getUrl(), e.getMessage());
            this.logger.error((Object)errorMsg);
            throw e;
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to GetCapabilities from service using URL '%s'. Error is %s.", this.parameters.getUrl(), e.getMessage());
            this.logger.error((Object)errorMsg);
            throw e;
        }
    }
}

