/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVNSqlJetUpdateStatement
extends SVNSqlJetSelectStatement {
    public SVNSqlJetUpdateStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        this(sDb, fromTable, null);
    }

    public SVNSqlJetUpdateStatement(SVNSqlJetDb sDb, Enum<?> fromTable, Enum<?> indexName) throws SVNException {
        super(sDb, fromTable, indexName);
        if (SVNWCDbSchema.NODES == fromTable) {
            SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
            this.addTrigger(trigger);
        }
        this.transactionMode = SqlJetTransactionMode.WRITE;
    }

    public void update(Map<String, Object> values) throws SqlJetException {
        if (this.getCursor() == null) {
            throw new UnsupportedOperationException();
        }
        this.beforeUpdate(this.getCursor(), values);
        this.getCursor().updateByFieldNames(values);
    }

    private void beforeUpdate(ISqlJetCursor cursor, Map<String, Object> values) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.beforeUpdate(cursor, values);
            }
            catch (SqlJetException e) {}
        }
    }

    @Override
    public long exec() throws SVNException {
        long n = 0L;
        try {
            this.statementStarted();
            while (this.next()) {
                Map<String, Object> values = this.getUpdateValues();
                this.update(values);
                ++n;
            }
            this.statementCompleted(null);
        }
        catch (SqlJetException e) {
            this.statementCompleted(e);
            SVNSqlJetDb.createSqlJetError(e);
        }
        return n;
    }

    public abstract Map<String, Object> getUpdateValues() throws SVNException;
}

