/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.pollconsumer.quartz2;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.CamelJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduledPollConsumerJob
extends CamelJob {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzScheduledPollConsumerJob.class);

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String routeId;
        LOG.trace("Execute job: {}", (Object)context);
        CamelContext camelContext = this.getCamelContext(context);
        Runnable task = (Runnable)context.getJobDetail().getJobDataMap().get((Object)"task");
        if (task == null && (routeId = (String)context.getJobDetail().getJobDataMap().get((Object)"routeId")) != null && camelContext != null) {
            for (Route route : camelContext.getRoutes()) {
                Consumer consumer;
                if (!route.getId().equals(routeId) || !((consumer = route.getConsumer()) instanceof Runnable)) continue;
                task = (Runnable)consumer;
                break;
            }
        }
        if (task != null) {
            LOG.trace("Running task: {}", (Object)task);
            task.run();
        }
    }
}

