/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;

public final class ByteBuddyCommons {
    public static final int VISIBILITY_MODIFIER_MASK = 7;
    public static final int GENERAL_MODIFIER_MASK = 135168;
    public static final int TYPE_MODIFIER_MASK = 163383;
    public static final int MEMBER_MODIFIER_MASK = 163391;
    public static final int FIELD_MODIFIER_MASK = 163583;
    public static final int METHOD_MODIFIER_MASK = 163839;
    private static final Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));

    private ByteBuddyCommons() {
        throw new UnsupportedOperationException();
    }

    public static <T> T nonNull(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> T[] nonNull(T[] value) {
        for (T object : value) {
            ByteBuddyCommons.nonNull(object);
        }
        return value;
    }

    public static <T extends TypeDescription> T nonVoid(T typeDescription) {
        if (ByteBuddyCommons.nonNull(typeDescription).represents(Void.TYPE)) {
            throw new IllegalArgumentException("Type must not be void");
        }
        return typeDescription;
    }

    public static <T extends Iterable<? extends TypeDescription>> T nonVoid(T typeDescriptions) {
        for (TypeDescription typeDescription : typeDescriptions) {
            if (!ByteBuddyCommons.nonNull(typeDescription).represents(Void.TYPE)) continue;
            throw new IllegalArgumentException("Type must not be void");
        }
        return typeDescriptions;
    }

    public static <T extends TypeDescription> T isInterface(T typeDescription) {
        if (!ByteBuddyCommons.nonNull(typeDescription).isInterface()) {
            throw new IllegalArgumentException(typeDescription + " is not an interface type");
        }
        return typeDescription;
    }

    public static <T extends TypeDescription> T[] isInterface(T[] typeDescription) {
        for (T aTypeDescription : typeDescription) {
            ByteBuddyCommons.isInterface(aTypeDescription);
        }
        return typeDescription;
    }

    public static <T extends TypeDescription> T isAnnotation(T typeDescriptions) {
        if (!ByteBuddyCommons.nonNull(typeDescriptions).isAnnotation()) {
            throw new IllegalArgumentException(typeDescriptions + " is not an annotation type");
        }
        return typeDescriptions;
    }

    public static <T extends Iterable<? extends TypeDescription>> T isInterface(T typeDescriptions) {
        for (TypeDescription typeDescription : typeDescriptions) {
            ByteBuddyCommons.isInterface(typeDescription);
        }
        return typeDescriptions;
    }

    public static <T extends TypeDescription> T isExtendable(T typeDescription) {
        if (ByteBuddyCommons.nonNull(typeDescription).isArray() || typeDescription.isPrimitive()) {
            throw new IllegalArgumentException(typeDescription + " is not implementable");
        }
        if (typeDescription.isFinal()) {
            throw new IllegalArgumentException("Cannot implement a final class such as " + typeDescription);
        }
        return typeDescription;
    }

    public static <T> List<T> join(List<? extends T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static <T> List<T> join(T element, List<? extends T> list) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.add(element);
        result.addAll(list);
        return result;
    }

    public static <T> List<T> join(List<? extends T> leftList, List<? extends T> rightList) {
        ArrayList<T> result = new ArrayList<T>(leftList.size() + rightList.size());
        result.addAll(leftList);
        result.addAll(rightList);
        return result;
    }

    public static <T> List<T> joinUnique(List<? extends T> list, T element) {
        return list.contains(element) ? new ArrayList<T>(list) : ByteBuddyCommons.join(list, element);
    }

    public static <T> List<T> joinUnique(T element, List<? extends T> list) {
        if (list.contains(element)) {
            ArrayList<T> result = new ArrayList<T>(list.size() + 1);
            result.add(element);
            for (T item : list) {
                if (item.equals(element)) continue;
                result.add(item);
            }
            return result;
        }
        return ByteBuddyCommons.join(element, list);
    }

    public static <T> List<T> joinUnique(List<? extends T> leftList, List<? extends T> rightList) {
        ArrayList<T> result = new ArrayList<T>(leftList.size() + rightList.size());
        result.addAll(leftList);
        HashSet<T> addedElements = new HashSet<T>(leftList.size() + rightList.size());
        addedElements.addAll(leftList);
        for (T element : rightList) {
            if (!addedElements.add(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static String isValidIdentifier(String identifier) {
        if (JAVA_KEYWORDS.contains(ByteBuddyCommons.nonNull(identifier))) {
            throw new IllegalArgumentException("Keyword cannot be used as Java identifier: " + identifier);
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("An empty string is not a valid Java identifier");
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            throw new IllegalArgumentException("Not a valid Java identifier: " + identifier);
        }
        for (char character : identifier.toCharArray()) {
            if (Character.isJavaIdentifierPart(character)) continue;
            throw new IllegalArgumentException("Not a valid Java identifier: " + identifier);
        }
        return identifier;
    }

    public static String isValidTypeName(String typeName) {
        String[] segments;
        for (String segment : segments = ByteBuddyCommons.nonNull(typeName).split("\\.")) {
            ByteBuddyCommons.isValidIdentifier(segment);
        }
        return typeName;
    }

    public static <T extends Collection<?>> T isNotEmpty(T collection, String exceptionMessage) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return collection;
    }

    public static <T extends Collection<?>> T isEmpty(T collection, String exceptionMessage) {
        if (collection.size() > 0) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return collection;
    }

    public static int resolveModifierContributors(int mask, ModifierContributor ... modifierContributor) {
        int modifier = 0;
        HashSet modifierContributorTypes = new HashSet(modifierContributor.length);
        for (ModifierContributor contributor : modifierContributor) {
            if (!modifierContributorTypes.add(contributor.getClass())) {
                throw new IllegalArgumentException(contributor + " is already registered with a different value");
            }
            modifier |= contributor.getMask();
        }
        if ((modifier & ~(mask | 0x1000)) != 0) {
            throw new IllegalArgumentException("Illegal modifiers " + Arrays.asList(modifierContributor));
        }
        return modifier;
    }

    public static <T extends Collection<?>> T unique(T items) {
        HashSet types = new HashSet(items.size());
        for (Object item : items) {
            if (types.add(item)) continue;
            throw new IllegalArgumentException("Non-unique item was found: " + item);
        }
        return items;
    }

    public static <T extends Iterable<? extends TypeDescription>> T isThrowable(T types) {
        for (TypeDescription typeDescription : types) {
            if (typeDescription.isAssignableTo(Throwable.class)) continue;
            throw new IllegalArgumentException("Not a isThrowable type: " + typeDescription);
        }
        return types;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ByteBuddyCommons.toList((Collection)iterable);
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T element : iterable) {
            list.add(element);
        }
        return list;
    }
}

