/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.MarcFactoryImpl;

public abstract class MarcFactory {
    static /* synthetic */ Class class$0;

    protected MarcFactory() {
    }

    public static MarcFactory newInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.marc4j.marc.MarcFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            loader = clazz.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = MarcFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (MarcFactory)t.newInstance();
            }
            catch (ClassNotFoundException e) {
                className = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (className == null && count < 3);
        return new MarcFactoryImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        String propertyName = "org.marc4j.marc.MarcFactory";
        switch (attempt) {
            case 0: {
                return System.getProperty("org.marc4j.marc.MarcFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "marc4j.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("org.marc4j.marc.MarcFactory");
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String serviceKey = "/META-INF/services/org.marc4j.marc.MarcFactory";
                    if (loader != null) {
                        inputStream = loader.getResourceAsStream(serviceKey);
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("org.marc4j.marc.MarcFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz2;
                        }
                        inputStream = clazz.getResourceAsStream(serviceKey);
                    }
                    InputStream in = inputStream;
                    if (in == null) return null;
                    BufferedReader r = new BufferedReader(new InputStreamReader(in));
                    String ret = r.readLine();
                    r.close();
                    return ret;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract ControlField newControlField();

    public abstract ControlField newControlField(String var1);

    public abstract ControlField newControlField(String var1, String var2);

    public abstract DataField newDataField();

    public abstract DataField newDataField(String var1, char var2, char var3);

    public abstract Leader newLeader();

    public abstract Leader newLeader(String var1);

    public abstract Record newRecord();

    public abstract Record newRecord(Leader var1);

    public abstract Record newRecord(String var1);

    public abstract Subfield newSubfield();

    public abstract Subfield newSubfield(char var1);

    public abstract Subfield newSubfield(char var1, String var2);
}

