/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.region;

import com.google.common.base.Optional;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.region.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
@Deprecated
public class GetMap {
    public static final String MAP_SRS_PARAM = "mapsrs";
    public static final String GEOM_SRS_PARAM = "geomsrs";
    public static final String WIDTH_PARAM = "width";
    public static final String GEOM_PARAM = "geom";
    public static final String GEOM_TYPE_PARAM = "geomtype";
    public static final String HEIGHT_PARAM = "height";
    public static final String BACKGROUND_PARAM = "background";
    public static final String OUTPUT_FILE_NAME = "outputFileName";
    public static final String SETTING_BACKGROUND = "settings";
    @Autowired
    private ServiceManager serviceManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        return MapRenderer.worldToScreenTransform(mapExtent, screenSize);
    }

    @PostConstruct
    public void init() {
    }

    @RequestMapping(value={"/{portal}/{lang:[a-z]{3}}/region.getmap.{imageFormat}"})
    public HttpEntity<byte[]> exec(@PathVariable String lang, @PathVariable String imageFormat, @RequestParam(value="id", required=false) String id, @RequestParam(value="mapsrs", defaultValue="EPSG:4326") String srs, @RequestParam(value="width", required=false) Integer width, @RequestParam(value="height", required=false) Integer height, @RequestParam(value="background", required=false) String background, @RequestParam(value="geom", required=false) String geomParam, @RequestParam(value="geomtype", defaultValue="WKT") String geomType, @RequestParam(value="geomsrs", defaultValue="EPSG:4326") String geomSrs, @RequestParam(value="outputFileName", required=false) String outputFileName, NativeWebRequest request) throws Exception {
        MapRenderer renderer;
        BufferedImage image;
        ServiceContext context = this.serviceManager.createServiceContext("region.getmap." + imageFormat, lang, (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));
        if (id == null && geomParam == null) {
            throw new BadParameterEx("id", (Object)"Either geom or id is required");
        }
        if (id != null && geomParam != null) {
            throw new BadParameterEx("id", (Object)"Only one of geom or id is permitted");
        }
        if (background != null && background.startsWith("http") && this.disableFullUrlBackgroundMapServices) {
            throw new BadParameterEx(BACKGROUND_PARAM, (Object)"Background layers from provided are not supported, use a preconfigured background layers map service.");
        }
        if (width != null && height != null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)"Only one of width and height can be defined currently.  Future versions may support this but it is not supported at the moment");
        }
        if (width == null && height == null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)"One of width or height parameters must be included in the request");
        }
        if (outputFileName == null) {
            outputFileName = "region.getmap." + imageFormat;
        }
        if (id != null) {
            Collection daos = context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
            for (RegionsDAO regionsDAO : daos) {
                Long lastModified;
                Request searchRequest = regionsDAO.createSearchRequest(context);
                searchRequest.id(id);
                Optional lastModifiedOption = searchRequest.getLastModified();
                if (!lastModifiedOption.isPresent() || (lastModified = (Long)lastModifiedOption.get()) == null || !request.checkNotModified(lastModified.longValue())) continue;
                return null;
            }
        } else if (request.checkNotModified(geomParam + srs + background)) {
            return null;
        }
        if ((image = (renderer = new MapRenderer(context)).render(id, srs, width, height, background, geomParam, geomType, geomSrs, null, null)) == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, imageFormat, out);
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)("inline; filename=\"" + outputFileName + "\""));
            if (id != null) {
                headers.add((Object)"Cache-Control", (Object)"no-cache");
            } else {
                headers.add((Object)"Cache-Control", (Object)("public, max-age: " + TimeUnit.DAYS.toSeconds(5L)));
            }
            headers.add((Object)"Content-Type", (Object)("image/" + imageFormat));
            HttpEntity httpEntity = new HttpEntity((Object)out.toByteArray(), (MultiValueMap)headers);
            return httpEntity;
        }
    }
}

