/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

class ImportConfig {
    private static final String CATEGORY_MAPPING = "categoryMapping";
    private static final String SCHEMA_MAPPING = "schemaMapping";
    private static final String MAPPING = "mapping";
    private static final String DEFAULT = "default";
    private static final String ATTR_DIR = "dir";
    private static final String ATTR_TO = "to";
    private Map<String, String> htCategId = new HashMap<String, String>();
    private Map<String, String> htCategMapping = new HashMap<String, String>();
    private Map<String, String> htSchemaMapping = new Hashtable<String, String>();
    private String defaultCateg;
    private String defaultSchema;

    public ImportConfig(Path configFile, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        Element config = Xml.loadFile((Path)configFile);
        this.fillCategIds(context);
        this.mapCategor(config.getChild(CATEGORY_MAPPING));
        this.mapSchemas(config.getChild(SCHEMA_MAPPING), dm);
    }

    public String mapCategory(String catDir) {
        String mapping = this.htCategMapping.get(catDir);
        if (mapping == null) {
            mapping = this.defaultCateg;
        }
        return mapping;
    }

    public String mapSchema(String catDir) {
        String mapping = this.htSchemaMapping.get(catDir);
        if (mapping == null) {
            mapping = this.defaultSchema;
        }
        return mapping;
    }

    private void fillCategIds(ServiceContext context) throws Exception {
        List metadataCategories = ((MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class)).findAll();
        for (MetadataCategory record : metadataCategories) {
            String id = "" + record.getId();
            String name = record.getName();
            this.htCategId.put(name, id);
        }
    }

    private void mapCategor(Element categMapping) {
        List list = categMapping.getChildren(MAPPING);
        for (Element el : list) {
            String dir = el.getAttributeValue(ATTR_DIR);
            String to = el.getAttributeValue(ATTR_TO);
            String categId = this.htCategId.get(to);
            if (categId == null) {
                throw new IllegalArgumentException("Category not found : " + to);
            }
            this.htCategMapping.put(dir, categId);
        }
        String defaultTo = categMapping.getChild(DEFAULT).getAttributeValue(ATTR_TO);
        String defaultId = this.htCategId.get(defaultTo);
        if (defaultId == null) {
            throw new IllegalArgumentException("Default category not found : " + defaultTo);
        }
        this.defaultCateg = defaultTo;
    }

    private void mapSchemas(Element schemaMapping, DataManager dm) {
        List list = schemaMapping.getChildren(MAPPING);
        for (Element el : list) {
            String dir = el.getAttributeValue(ATTR_DIR);
            String to = el.getAttributeValue(ATTR_TO);
            if (!dm.existsSchema(to)) {
                throw new IllegalArgumentException("Schema not found : " + to);
            }
            this.htSchemaMapping.put(dir, to);
        }
        String defaultTo = schemaMapping.getChild(DEFAULT).getAttributeValue(ATTR_TO);
        if (!dm.existsSchema(defaultTo)) {
            throw new IllegalArgumentException("Default schema not found : " + defaultTo);
        }
        this.defaultSchema = defaultTo;
    }
}

